/*
  This file is part of the clazy static checker.

  Copyright (C) 2017 Klarälvdalens Datakonsult AB, a KDAB Group company, info@kdab.com
  Author: Sérgio Martins <sergio.martins@kdab.com>

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this library; see the file COPYING.LIB.  If not, write to
  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
  Boston, MA 02110-1301, USA.
*/

#include "tr-non-literal.h"
#include "Utils.h"
#include "HierarchyUtils.h"
#include "QtUtils.h"
#include "TypeUtils.h"
#include "checkmanager.h"

#include <clang/AST/AST.h>

using namespace clang;
using namespace std;


TrNonLiteral::TrNonLiteral(const std::string &name, ClazyContext *context)
    : CheckBase(name, context)
{
}


void TrNonLiteral::VisitStmt(clang::Stmt *stmt)
{
    auto callExpr = dyn_cast<CallExpr>(stmt);
    if (!callExpr || callExpr->getNumArgs() <= 0)
        return;

    FunctionDecl *func = callExpr->getDirectCallee();
    if (!func || func->getQualifiedNameAsString() != "QObject::tr")
        return;

    Expr *arg1 = callExpr->getArg(0);
    if (HierarchyUtils::getFirstChildOfType2<StringLiteral>(arg1) == nullptr)
        emitWarning(stmt, "tr() without a literal string");
}

REGISTER_CHECK("tr-non-literal", TrNonLiteral, HiddenCheckLevel)
