/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.axiom.test;

import static org.assertj.core.api.Assertions.assertThat;
import static org.ops4j.pax.exam.CoreOptions.junitBundles;
import static org.ops4j.pax.exam.CoreOptions.options;
import static org.ops4j.pax.exam.CoreOptions.url;

import org.apache.axiom.util.activation.DataHandlerUtils;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ops4j.pax.exam.Configuration;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.junit.PaxExam;
import org.ops4j.pax.exam.spi.reactors.ExamReactorStrategy;
import org.ops4j.pax.exam.spi.reactors.PerClass;

import jakarta.activation.DataHandler;
import jakarta.mail.util.ByteArrayDataSource;

@RunWith(PaxExam.class)
@ExamReactorStrategy(PerClass.class)
public class DataHandlerUtilsTest {
    @Configuration
    public static Option[] configuration() {
        return options(
                url("link:classpath:jakarta.activation-api.link"),
                url("link:classpath:jakarta.mail-api.link"),
                url("link:classpath:org.apache.commons.commons-io.link"),
                url("link:classpath:org.apache.james.apache-mime4j-core.link"),
                url("link:classpath:org.apache.ws.commons.axiom.axiom-api.link"),
                url("link:classpath:org.apache.ws.commons.axiom.axiom-jakarta-activation.link"),
                junitBundles(),
                url("link:classpath:net.bytebuddy.byte-buddy.link"),
                url("link:classpath:assertj-core.link"));
    }

    @Test
    public void testByteArrayDataSourceToBlobGetSize() {
        assertThat(
                        DataHandlerUtils.toBlob(
                                        new DataHandler(
                                                new ByteArrayDataSource(
                                                        new byte[123], "application/octet-stream")))
                                .getSize())
                .isEqualTo(123);
    }
}
