/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.events;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.events.ComponentBulletin;
import org.apache.nifi.events.SystemBulletin;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.reporting.Bulletin;
import org.apache.nifi.reporting.ComponentType;

public final class BulletinFactory {
    private static final AtomicLong currentId = new AtomicLong(0L);

    private BulletinFactory() {
    }

    public static Bulletin createBulletin(Connectable connectable, String category, String severity, String message) {
        ComponentType type = BulletinFactory.getComponentType(connectable);
        ProcessGroup group = connectable.getProcessGroup();
        String groupId = connectable.getProcessGroupIdentifier();
        String groupName = group == null ? null : group.getName();
        String groupPath = BulletinFactory.buildGroupPath(group);
        return BulletinFactory.createBulletin(groupId, groupName, connectable.getIdentifier(), type, connectable.getName(), category, severity, message, groupPath, null);
    }

    public static Bulletin createBulletin(Connectable connectable, String category, String severity, String message, String flowFileUUID) {
        ComponentType type = BulletinFactory.getComponentType(connectable);
        ProcessGroup group = connectable.getProcessGroup();
        String groupId = connectable.getProcessGroupIdentifier();
        String groupName = group == null ? null : group.getName();
        String groupPath = BulletinFactory.buildGroupPath(group);
        return BulletinFactory.createBulletin(groupId, groupName, connectable.getIdentifier(), type, connectable.getName(), category, severity, message, groupPath, flowFileUUID);
    }

    private static String buildGroupPath(ProcessGroup group) {
        if (group == null) {
            return null;
        }
        Object path = group.getName();
        for (ProcessGroup parent = group.getParent(); parent != null; parent = parent.getParent()) {
            path = parent.getName() + " / " + (String)path;
        }
        return path;
    }

    public static Bulletin createBulletin(String groupId, String sourceId, ComponentType sourceType, String sourceName, String category, String severity, String message) {
        ComponentBulletin bulletin = new ComponentBulletin(currentId.getAndIncrement());
        bulletin.setGroupId(groupId);
        bulletin.setSourceId(sourceId);
        bulletin.setSourceType(sourceType);
        bulletin.setSourceName(sourceName);
        bulletin.setCategory(category);
        bulletin.setLevel(severity);
        bulletin.setMessage(message);
        return bulletin;
    }

    public static Bulletin createBulletin(String groupId, String groupName, String sourceId, ComponentType sourceType, String sourceName, String category, String severity, String message) {
        ComponentBulletin bulletin = new ComponentBulletin(currentId.getAndIncrement());
        bulletin.setGroupId(groupId);
        bulletin.setGroupName(groupName);
        bulletin.setSourceId(sourceId);
        bulletin.setSourceType(sourceType);
        bulletin.setSourceName(sourceName);
        bulletin.setCategory(category);
        bulletin.setLevel(severity);
        bulletin.setMessage(message);
        return bulletin;
    }

    public static Bulletin createBulletin(String groupId, String groupName, String sourceId, ComponentType sourceType, String sourceName, String category, String severity, String message, String groupPath, String flowFileUUID) {
        ComponentBulletin bulletin = new ComponentBulletin(currentId.getAndIncrement());
        bulletin.setGroupId(groupId);
        bulletin.setGroupName(groupName);
        bulletin.setGroupPath(groupPath);
        bulletin.setSourceId(sourceId);
        bulletin.setSourceType(sourceType);
        bulletin.setSourceName(sourceName);
        bulletin.setCategory(category);
        bulletin.setLevel(severity);
        bulletin.setMessage(message);
        bulletin.setFlowFileUuid(flowFileUUID);
        return bulletin;
    }

    public static Bulletin createBulletin(String category, String severity, String message) {
        SystemBulletin bulletin = new SystemBulletin(currentId.getAndIncrement());
        bulletin.setCategory(category);
        bulletin.setLevel(severity);
        bulletin.setMessage(message);
        bulletin.setSourceType(ComponentType.FLOW_CONTROLLER);
        return bulletin;
    }

    private static ComponentType getComponentType(Connectable connectable) {
        switch (connectable.getConnectableType()) {
            case REMOTE_INPUT_PORT: 
            case REMOTE_OUTPUT_PORT: {
                return ComponentType.REMOTE_PROCESS_GROUP;
            }
            case INPUT_PORT: {
                return ComponentType.INPUT_PORT;
            }
            case OUTPUT_PORT: {
                return ComponentType.OUTPUT_PORT;
            }
            case STATELESS_GROUP: {
                return ComponentType.PROCESS_GROUP;
            }
        }
        return ComponentType.PROCESSOR;
    }
}

