/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.webconsoleplugin.impl;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.dto.ServiceReferenceDTO;
import org.osgi.service.servlet.runtime.HttpServiceRuntime;
import org.osgi.service.servlet.runtime.dto.ErrorPageDTO;
import org.osgi.service.servlet.runtime.dto.FailedErrorPageDTO;
import org.osgi.service.servlet.runtime.dto.FailedFilterDTO;
import org.osgi.service.servlet.runtime.dto.FailedListenerDTO;
import org.osgi.service.servlet.runtime.dto.FailedPreprocessorDTO;
import org.osgi.service.servlet.runtime.dto.FailedResourceDTO;
import org.osgi.service.servlet.runtime.dto.FailedServletContextDTO;
import org.osgi.service.servlet.runtime.dto.FailedServletDTO;
import org.osgi.service.servlet.runtime.dto.FilterDTO;
import org.osgi.service.servlet.runtime.dto.ListenerDTO;
import org.osgi.service.servlet.runtime.dto.PreprocessorDTO;
import org.osgi.service.servlet.runtime.dto.RequestInfoDTO;
import org.osgi.service.servlet.runtime.dto.ResourceDTO;
import org.osgi.service.servlet.runtime.dto.RuntimeDTO;
import org.osgi.service.servlet.runtime.dto.ServletContextDTO;
import org.osgi.service.servlet.runtime.dto.ServletDTO;
import org.owasp.encoder.Encode;

public class HttpServicePlugin
extends HttpServlet {
    private static final String ATTR_TEST = "test";
    private static final String ATTR_SUBMIT = "resolve";
    private static final String LINK_MARKER_START = "${#link:";
    private static final String LINK_MARKER_END = "${link#}";
    private final BundleContext context;
    private final HttpServiceRuntime runtime;

    public HttpServicePlugin(BundleContext context, HttpServiceRuntime runtime) {
        this.context = context;
        this.runtime = runtime;
    }

    private String getTestPath(HttpServletRequest request) {
        String test = request.getParameter(ATTR_TEST);
        test = test != null && !test.isEmpty() ? test.trim() : null;
        return test;
    }

    private String getRequestPath(HttpServletRequest request) {
        int pos = request.getPathInfo().indexOf("/", 1);
        return request.getContextPath().concat(request.getServletPath()).concat(pos == -1 ? request.getPathInfo() : request.getPathInfo().substring(0, pos));
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String test = this.getTestPath(request);
        String path = this.getRequestPath(request);
        String redirectTo = test == null ? path : path.concat("?").concat(ATTR_TEST).concat("=").concat(URLEncoder.encode(test, StandardCharsets.UTF_8));
        response.sendRedirect(redirectTo);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        RuntimeDTO dto = this.runtime.getRuntimeDTO();
        PrintWriter pw = resp.getWriter();
        String path = this.getRequestPath(req);
        this.printForm(pw, this.getTestPath(req), path);
        this.printRuntimeDetails(pw, dto.serviceDTO);
        this.printPreprocessorDetails(pw, dto.preprocessorDTOs);
        for (ServletContextDTO servletContextDTO : dto.servletContextDTOs) {
            this.printContextDetails(pw, servletContextDTO);
        }
        this.printFailedPreprocessorDetails(pw, dto);
        for (ServletContextDTO servletContextDTO : dto.failedServletContextDTOs) {
            this.printFailedContextDetails(pw, (FailedServletContextDTO)servletContextDTO);
        }
        this.printFailedServletDetails(pw, dto);
        this.printFailedFilterDetails(pw, dto);
        this.printFailedResourceDetails(pw, dto);
        this.printFailedErrorPageDetails(pw, dto);
        this.printFailedListenerDetails(pw, dto);
        pw.println("<br/>");
    }

    private void printForm(PrintWriter pw, String value, String path) {
        pw.println("<table class='content' cellpadding='0' cellspacing='0' width='100%'>");
        this.separatorHtml(pw);
        this.titleHtml(pw, "Test Servlet Resolution", "To test the servlet resolution, enter a relative URL into the field and click 'Resolve'.");
        pw.println("<tr class='content'>");
        pw.println("<td class='content'>Test</td>");
        pw.print("<td class='content' colspan='2'>");
        pw.print("<form method='POST' action='");
        pw.print(path);
        pw.print("'>");
        pw.print("<input type='text' name='test' value='");
        if (value != null) {
            pw.print(Encode.forHtmlAttribute((String)value));
        }
        pw.println("' class='input' size='50'>");
        pw.println("&nbsp;&nbsp;<input type='submit' name='resolve' value='Resolve' class='submit'>");
        pw.print("</form>");
        pw.print("</td>");
        pw.println("</tr>");
        if (value != null) {
            RequestInfoDTO dto = this.runtime.calculateRequestInfoDTO(value);
            if (dto.resourceDTO == null && dto.servletDTO == null) {
                pw.println("<tr class='content'>");
                pw.println("<td class='content'>Result</td>");
                pw.print("<td class='content' colspan='2'>");
                pw.print("<404>");
                pw.println("</td>");
                pw.println("</tr>");
            } else {
                StringBuilder sb;
                boolean odd = false;
                odd = this.printRow(pw, odd, "", "", "");
                StringBuilder sbc = new StringBuilder();
                ServiceReference<?> refc = this.getServiceReference(dto.servletContextId);
                sbc.append("${service.id} : ");
                this.appendServiceLink(sbc, dto.servletContextId);
                sbc.append("\n");
                this.appendServiceRanking(sbc, refc);
                if (refc != null) {
                    sbc.append("${bundle} : ");
                    this.appendBundleLink(sbc, refc.getBundle().getBundleId(), refc.getBundle().getSymbolicName());
                    sbc.append("\n");
                }
                odd = this.printRow(pw, odd, "${Servlet Context}", sbc.toString(), "");
                for (FilterDTO f : dto.filterDTOs) {
                    StringBuilder sb2 = new StringBuilder();
                    ServiceReference<?> ref = this.getServiceReference(f.serviceId);
                    sb2.append("${service.id} : ");
                    this.appendServiceLink(sb2, f.serviceId);
                    sb2.append("\n");
                    this.appendServiceRanking(sb2, ref);
                    if (ref != null) {
                        sb2.append("${bundle} : ");
                        this.appendBundleLink(sb2, ref.getBundle().getBundleId(), ref.getBundle().getSymbolicName());
                        sb2.append("\n");
                    }
                    odd = this.printRow(pw, odd, "${Filter}", sb2.toString(), "");
                }
                if (dto.servletDTO != null) {
                    sb = new StringBuilder();
                    ServiceReference<?> ref = this.getServiceReference(dto.servletDTO.serviceId);
                    sb.append("${service.id} : ");
                    this.appendServiceLink(sb, dto.servletDTO.serviceId);
                    sb.append("\n");
                    this.appendServiceRanking(sb, ref);
                    if (ref != null) {
                        sb.append("${bundle} : ");
                        this.appendBundleLink(sb, ref.getBundle().getBundleId(), ref.getBundle().getSymbolicName());
                        sb.append("\n");
                    }
                    odd = this.printRow(pw, odd, "${Servlet}", sb.toString(), "");
                } else {
                    sb = new StringBuilder();
                    ServiceReference<?> ref = this.getServiceReference(dto.resourceDTO.serviceId);
                    sb.append("${service.id} : ");
                    this.appendServiceLink(sb, dto.resourceDTO.serviceId);
                    sb.append("\n");
                    this.appendServiceRanking(sb, ref);
                    if (ref != null) {
                        sb.append("${bundle} : ");
                        this.appendBundleLink(sb, ref.getBundle().getBundleId(), ref.getBundle().getSymbolicName());
                        sb.append("\n");
                    }
                    odd = this.printRow(pw, odd, "${Resource}", sb.toString(), "");
                }
            }
        }
        pw.println("</table>");
    }

    private void titleHtml(PrintWriter pw, String title, String description) {
        pw.println("<tr class='content'>");
        pw.println("<th colspan='3'class='content container'>" + title + "</th>");
        pw.println("</tr>");
        if (description != null) {
            pw.println("<tr class='content'>");
            pw.println("<td colspan='3'class='content'>" + description + "</th>");
            pw.println("</tr>");
        }
    }

    private void separatorHtml(PrintWriter pw) {
        pw.println("<tr class='content'>");
        pw.println("<td class='content' colspan='3'>&nbsp;</td>");
        pw.println("</tr>");
    }

    private String getValueAsString(Object value) {
        if (value.getClass().isArray()) {
            if (value instanceof long[]) {
                return Arrays.toString((long[])value);
            }
            if (value instanceof int[]) {
                return Arrays.toString((int[])value);
            }
            if (value instanceof double[]) {
                return Arrays.toString((double[])value);
            }
            if (value instanceof byte[]) {
                return Arrays.toString((byte[])value);
            }
            if (value instanceof float[]) {
                return Arrays.toString((float[])value);
            }
            if (value instanceof short[]) {
                return Arrays.toString((short[])value);
            }
            if (value instanceof boolean[]) {
                return Arrays.toString((boolean[])value);
            }
            if (value instanceof char[]) {
                return Arrays.toString((char[])value);
            }
            return Arrays.toString((Object[])value);
        }
        return value.toString();
    }

    private void printRuntimeDetails(PrintWriter pw, ServiceReferenceDTO dto) {
        pw.println("<p class=\"statline ui-state-highlight\">${Runtime Properties}</p>");
        pw.println("<table class=\"nicetable\">");
        pw.println("<thead><tr>");
        pw.println("<th class=\"header\">${Name}</th>");
        pw.println("<th class=\"header\">${Value}</th>");
        pw.println("</tr></thead>");
        boolean odd = true;
        for (Map.Entry prop : dto.properties.entrySet()) {
            odd = this.printRow(pw, odd, (String)prop.getKey(), this.getValueAsString(prop.getValue()));
        }
        pw.println("</table>");
        pw.println("<br/>");
    }

    private void appendServiceLink(StringBuilder sb, long serviceId) {
        String val = String.valueOf(serviceId);
        if (serviceId < 0L) {
            sb.append(val);
            return;
        }
        sb.append(LINK_MARKER_START);
        sb.append('S');
        sb.append(val);
        sb.append('}');
        sb.append(val);
        sb.append(LINK_MARKER_END);
    }

    private String getServiceLink(long serviceId) {
        StringBuilder sb = new StringBuilder();
        this.appendServiceLink(sb, serviceId);
        return sb.toString();
    }

    private void appendBundleLink(StringBuilder sb, long bundleId, String text) {
        String val = String.valueOf(bundleId);
        sb.append(LINK_MARKER_START);
        sb.append('B');
        sb.append(val);
        sb.append('}');
        sb.append(text);
        sb.append(LINK_MARKER_END);
    }

    private void printPreprocessorDetails(PrintWriter pw, PreprocessorDTO[] dtos) {
        if (dtos.length == 0) {
            return;
        }
        pw.println("<p class=\"statline ui-state-highlight\">${Preprocessor Services}</p>");
        pw.println("<table class=\"nicetable\">");
        pw.println("<thead><tr>");
        pw.println("<th class=\"header\">${Preprocessor}</th>");
        pw.println("</tr></thead>");
        boolean odd = true;
        for (PreprocessorDTO pp : dtos) {
            StringBuilder sb = new StringBuilder();
            ServiceReference<?> ref = this.getServiceReference(pp.serviceId);
            sb.append("${service.id} : ");
            this.appendServiceLink(sb, pp.serviceId);
            sb.append("\n");
            this.appendServiceRanking(sb, ref);
            if (ref != null) {
                sb.append("${bundle} : ");
                this.appendBundleLink(sb, ref.getBundle().getBundleId(), ref.getBundle().getSymbolicName());
                sb.append("\n");
            }
            odd = this.printRow(pw, odd, sb.toString());
        }
        pw.println("</table>");
        pw.println("<br/>");
    }

    private boolean printRow(PrintWriter pw, boolean odd, String ... columns) {
        pw.print("<tr class=\"");
        if (odd) {
            pw.print("odd");
        } else {
            pw.print("even");
        }
        pw.println(" ui-state-default\">");
        for (String val : columns) {
            pw.print("<td>");
            if (val != null) {
                int pos;
                String text = Encode.forHtmlContent((String)val).replace("\n", "<br/>");
                while ((pos = text.indexOf(LINK_MARKER_START)) != -1) {
                    int endPos = text.indexOf("}", pos);
                    char type = text.charAt(pos + LINK_MARKER_START.length());
                    int id = Integer.valueOf(text.substring(pos + LINK_MARKER_START.length() + 1, endPos));
                    int tokenEndPos = text.indexOf(LINK_MARKER_END, pos);
                    String linkTest = text.substring(endPos + 1, tokenEndPos);
                    text = text.substring(0, pos).concat("<a href=\"${appRoot}/").concat(type == 'S' ? "services/" : "bundles/").concat(String.valueOf(id)).concat("\">").concat(linkTest).concat("</a>").concat(text.substring(tokenEndPos + LINK_MARKER_END.length()));
                }
                pw.print(text);
            }
            pw.println("</td>");
        }
        pw.println("</tr>");
        return !odd;
    }

    private String getContextPath(String path) {
        if (path.length() == 0) {
            return "<root>";
        }
        return path;
    }

    private boolean printServiceRankingRow(PrintWriter pw, long serviceId, boolean odd) {
        Object obj;
        int ranking = 0;
        ServiceReference<?> ref = this.getServiceReference(serviceId);
        if (ref != null && (obj = ref.getProperty("service.ranking")) instanceof Integer) {
            ranking = (Integer)obj;
        }
        return this.printRow(pw, odd, "${ranking}", String.valueOf(ranking));
    }

    private void printContextDetails(PrintWriter pw, ServletContextDTO dto) {
        pw.print("<p class=\"statline ui-state-highlight\">${Servlet Context} '");
        pw.print(Encode.forHtmlContent((String)dto.name));
        pw.println("'</p>");
        pw.println("<table class=\"nicetable\">");
        boolean odd = true;
        pw.println("<thead><tr>");
        pw.println("<th class=\"header\">${Name}</th>");
        pw.println("<th class=\"header\">${Value)}</th>");
        pw.println("</tr></thead>");
        odd = this.printRow(pw, odd, "${Path}", this.getContextPath(dto.contextPath));
        odd = this.printRow(pw, odd, "${service.id}", this.getServiceLink(dto.serviceId));
        odd = this.printServiceRankingRow(pw, dto.serviceId, odd);
        pw.println("</table>");
        this.printServletDetails(pw, dto);
        this.printFilterDetails(pw, dto);
        this.printResourceDetails(pw, dto);
        this.printErrorPageDetails(pw, dto);
        this.printListenerDetails(pw, dto);
        pw.println("<br/>");
    }

    private void printFailedContextDetails(PrintWriter pw, FailedServletContextDTO dto) {
        pw.print("<p class=\"statline ui-state-highlight\">${Servlet Context} '");
        pw.print(Encode.forHtmlContent((String)dto.name));
        pw.println("'</p>");
        pw.println("<table class=\"nicetable\">");
        boolean odd = true;
        pw.println("<thead><tr>");
        pw.println("<th class=\"header\">${Name}</th>");
        pw.println("<th class=\"header\">${Value)}</th>");
        pw.println("</tr></thead>");
        odd = this.printRow(pw, odd, "${Path}", dto.contextPath == null ? dto.contextPath : this.getContextPath(dto.contextPath));
        odd = this.printRow(pw, odd, "${reason}", this.getErrorText(dto.failureReason));
        odd = this.printRow(pw, odd, "${service.id}", this.getServiceLink(dto.serviceId));
        pw.println("</table>");
    }

    private void appendServiceRanking(StringBuilder sb, ServiceReference<?> ref) {
        Object obj;
        int ranking = 0;
        if (ref != null && (obj = ref.getProperty("service.ranking")) instanceof Integer) {
            ranking = (Integer)obj;
        }
        sb.append("${ranking} : ").append(String.valueOf(ranking)).append("\n");
    }

    /*
     * WARNING - void declaration
     */
    private void printFilterDetails(PrintWriter pw, ServletContextDTO dto) {
        if (dto.filterDTOs.length == 0) {
            return;
        }
        pw.print("<p class=\"statline ui-state-highlight\">${Servlet Context} '");
        pw.print(Encode.forHtmlContent((String)dto.name));
        pw.println("' ${Registered Filter Services}</p>");
        pw.println("<table class=\"nicetable\">");
        pw.println("<thead><tr>");
        pw.println("<th class=\"header\">${Pattern}</th>");
        pw.println("<th class=\"header\">${Filter}</th>");
        pw.println("<th class=\"header\">${Info}</th>");
        pw.println("</tr></thead>");
        boolean odd = true;
        for (FilterDTO filter : dto.filterDTOs) {
            void var13_15;
            ServiceReference<?> ref = this.getServiceReference(filter.serviceId);
            StringBuilder sb = new StringBuilder();
            sb.append("${service.id} : ");
            this.appendServiceLink(sb, filter.serviceId);
            sb.append("\n");
            this.appendServiceRanking(sb, ref);
            sb.append("${async} : ").append(String.valueOf(filter.asyncSupported)).append("\n");
            sb.append("${dispatcher} : ").append(this.getValueAsString(filter.dispatcher)).append("\n");
            if (ref != null) {
                sb.append("${bundle} : ");
                this.appendBundleLink(sb, ref.getBundle().getBundleId(), ref.getBundle().getSymbolicName());
                sb.append("\n");
            }
            ArrayList<Object> patterns = new ArrayList<Object>();
            patterns.addAll(Arrays.asList(filter.patterns));
            patterns.addAll(Arrays.asList(filter.regexs));
            String[] stringArray = filter.servletNames;
            int n = stringArray.length;
            boolean bl = false;
            while (var13_15 < n) {
                String name = stringArray[var13_15];
                patterns.add("Servlet : " + name);
                ++var13_15;
            }
            Collections.sort(patterns);
            StringBuilder psb = new StringBuilder();
            for (String string : patterns) {
                psb.append(string).append('\n');
            }
            odd = this.printRow(pw, odd, psb.toString(), filter.name, sb.toString());
        }
        pw.println("</table>");
    }

    private String getErrorText(int reason) {
        switch (reason) {
            case 4: {
                return "Exception on init";
            }
            case 1: {
                return "No match";
            }
            case 7: {
                return "In use";
            }
            case 5: {
                return "Not gettable";
            }
            case 2: {
                return "Context failure";
            }
            case 3: {
                return "Shadowed";
            }
            case 6: {
                return "Invalid";
            }
        }
        return "unknown";
    }

    private void printFailedPreprocessorDetails(PrintWriter pw, RuntimeDTO dto) {
        if (dto.failedPreprocessorDTOs.length == 0) {
            return;
        }
        pw.print("<p class=\"statline ui-state-highlight\">${Failed Preprocessor Services}</p>");
        pw.println("<table class=\"nicetable\">");
        pw.println("<thead><tr>");
        pw.println("<th class=\"header\">${Preprocessor}</th>");
        pw.println("<th class=\"header\">${Info}</th>");
        pw.println("</tr></thead>");
        boolean odd = true;
        for (FailedPreprocessorDTO pp : dto.failedPreprocessorDTOs) {
            String reason = this.getErrorText(pp.failureReason);
            StringBuilder sb = new StringBuilder();
            ServiceReference<?> ref = this.getServiceReference(pp.serviceId);
            sb.append("${service.id} : ");
            this.appendServiceLink(sb, pp.serviceId);
            sb.append("\n");
            this.appendServiceRanking(sb, ref);
            if (ref != null) {
                sb.append("${bundle} : ");
                this.appendBundleLink(sb, ref.getBundle().getBundleId(), ref.getBundle().getSymbolicName());
                sb.append("\n");
            }
            odd = this.printRow(pw, odd, sb.toString(), reason);
        }
        pw.println("</table>");
    }

    /*
     * WARNING - void declaration
     */
    private void printFailedFilterDetails(PrintWriter pw, RuntimeDTO dto) {
        if (dto.failedFilterDTOs.length == 0) {
            return;
        }
        pw.print("<p class=\"statline ui-state-highlight\">${Failed Filter Services}</p>");
        pw.println("<table class=\"nicetable\">");
        pw.println("<thead><tr>");
        pw.println("<th class=\"header\">${Pattern}</th>");
        pw.println("<th class=\"header\">${Filter}</th>");
        pw.println("<th class=\"header\">${Info}</th>");
        pw.println("</tr></thead>");
        boolean odd = true;
        for (FailedFilterDTO filter : dto.failedFilterDTOs) {
            void var13_15;
            StringBuilder sb = new StringBuilder();
            sb.append("${reason} : ").append(this.getErrorText(filter.failureReason)).append("\n");
            ServiceReference<?> ref = this.getServiceReference(filter.serviceId);
            sb.append("${service.id} : ");
            this.appendServiceLink(sb, filter.serviceId);
            sb.append("\n");
            this.appendServiceRanking(sb, ref);
            sb.append("${async} : ").append(String.valueOf(filter.asyncSupported)).append("\n");
            sb.append("${dispatcher} : ").append(this.getValueAsString(filter.dispatcher)).append("\n");
            if (ref != null) {
                sb.append("${bundle} : ");
                this.appendBundleLink(sb, ref.getBundle().getBundleId(), ref.getBundle().getSymbolicName());
                sb.append("\n");
            }
            ArrayList<Object> patterns = new ArrayList<Object>();
            patterns.addAll(Arrays.asList(filter.patterns));
            patterns.addAll(Arrays.asList(filter.regexs));
            String[] stringArray = filter.servletNames;
            int n = stringArray.length;
            boolean bl = false;
            while (var13_15 < n) {
                String name = stringArray[var13_15];
                patterns.add("Servlet : " + name);
                ++var13_15;
            }
            Collections.sort(patterns);
            StringBuilder psb = new StringBuilder();
            for (String string : patterns) {
                psb.append(string).append('\n');
            }
            odd = this.printRow(pw, odd, psb.toString(), filter.name, sb.toString());
        }
        pw.println("</table>");
    }

    private ServiceReference<?> getServiceReference(long serviceId) {
        if (serviceId > 0L) {
            try {
                ServiceReference[] ref = this.context.getServiceReferences((String)null, "(service.id=" + String.valueOf(serviceId) + ")");
                if (ref != null && ref.length > 0) {
                    return ref[0];
                }
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    private void printServletDetails(PrintWriter pw, ServletContextDTO dto) {
        if (dto.servletDTOs.length == 0) {
            return;
        }
        pw.print("<p class=\"statline ui-state-highlight\">${Servlet Context} '");
        pw.print(Encode.forHtmlContent((String)dto.name));
        pw.println("' ${Registered Servlet Services}</p>");
        pw.println("<table class=\"nicetable\">");
        pw.println("<thead><tr>");
        pw.println("<th class=\"header\">${Path}</th>");
        pw.println("<th class=\"header\">${Name}</th>");
        pw.println("<th class=\"header\">${Info}</th>");
        pw.println("</tr></thead>");
        boolean odd = true;
        for (ServletDTO servlet : dto.servletDTOs) {
            StringBuilder sb = new StringBuilder();
            ServiceReference<?> ref = this.getServiceReference(servlet.serviceId);
            sb.append("${service.id} : ");
            this.appendServiceLink(sb, servlet.serviceId);
            sb.append("\n");
            this.appendServiceRanking(sb, ref);
            sb.append("${async} : ").append(String.valueOf(servlet.asyncSupported)).append("\n");
            if (ref != null) {
                sb.append("${bundle} : ");
                this.appendBundleLink(sb, ref.getBundle().getBundleId(), ref.getBundle().getSymbolicName());
                sb.append("\n");
            }
            StringBuilder psb = new StringBuilder();
            for (String p : servlet.patterns) {
                psb.append(p).append('\n');
            }
            odd = this.printRow(pw, odd, psb.toString(), servlet.name, sb.toString());
        }
        pw.println("</table>");
    }

    private void printFailedServletDetails(PrintWriter pw, RuntimeDTO dto) {
        if (dto.failedServletDTOs.length == 0) {
            return;
        }
        pw.print("<p class=\"statline ui-state-highlight\">${Failed Servlet Services}</p>");
        pw.println("<table class=\"nicetable\">");
        pw.println("<thead><tr>");
        pw.println("<th class=\"header\">${Path}</th>");
        pw.println("<th class=\"header\">${Name}</th>");
        pw.println("<th class=\"header\">${Info}</th>");
        pw.println("</tr></thead>");
        boolean odd = true;
        for (FailedServletDTO servlet : dto.failedServletDTOs) {
            StringBuilder sb = new StringBuilder();
            sb.append("${reason} : ").append(this.getErrorText(servlet.failureReason)).append("\n");
            ServiceReference<?> ref = this.getServiceReference(servlet.serviceId);
            sb.append("${service.id} : ");
            this.appendServiceLink(sb, servlet.serviceId);
            sb.append("\n");
            this.appendServiceRanking(sb, ref);
            sb.append("${async} : ").append(String.valueOf(servlet.asyncSupported)).append("\n");
            if (ref != null) {
                sb.append("${bundle} : ");
                this.appendBundleLink(sb, ref.getBundle().getBundleId(), ref.getBundle().getSymbolicName());
                sb.append("\n");
            }
            StringBuilder psb = new StringBuilder();
            for (String p : servlet.patterns) {
                psb.append(p).append('\n');
            }
            odd = this.printRow(pw, odd, psb.toString(), servlet.name, sb.toString());
        }
        pw.println("</table>");
    }

    private void printResourceDetails(PrintWriter pw, ServletContextDTO dto) {
        if (dto.resourceDTOs.length == 0) {
            return;
        }
        pw.print("<p class=\"statline ui-state-highlight\">${Servlet Context} '");
        pw.print(Encode.forHtmlContent((String)dto.name));
        pw.println("' ${Registered Resource Services}</p>");
        pw.println("<table class=\"nicetable\">");
        pw.println("<thead><tr>");
        pw.println("<th class=\"header\">${Path}</th>");
        pw.println("<th class=\"header\">${Prefix}</th>");
        pw.println("<th class=\"header\">${Info}</th>");
        pw.println("</tr></thead>");
        boolean odd = true;
        for (ResourceDTO rsrc : dto.resourceDTOs) {
            StringBuilder sb = new StringBuilder();
            ServiceReference<?> ref = this.getServiceReference(rsrc.serviceId);
            sb.append("${service.id} : ");
            this.appendServiceLink(sb, rsrc.serviceId);
            sb.append("\n");
            this.appendServiceRanking(sb, ref);
            if (ref != null) {
                sb.append("${bundle} : ");
                this.appendBundleLink(sb, ref.getBundle().getBundleId(), ref.getBundle().getSymbolicName());
                sb.append("\n");
            }
            StringBuilder psb = new StringBuilder();
            for (String p : rsrc.patterns) {
                psb.append(p).append('\n');
            }
            odd = this.printRow(pw, odd, psb.toString(), rsrc.prefix, sb.toString());
        }
        pw.println("</table>");
    }

    private void printFailedResourceDetails(PrintWriter pw, RuntimeDTO dto) {
        if (dto.failedResourceDTOs.length == 0) {
            return;
        }
        pw.print("<p class=\"statline ui-state-highlight\">${Failed Resource Services}</p>");
        pw.println("<table class=\"nicetable\">");
        pw.println("<thead><tr>");
        pw.println("<th class=\"header\">${Path}</th>");
        pw.println("<th class=\"header\">${Prefix}</th>");
        pw.println("<th class=\"header\">${Info}</th>");
        pw.println("</tr></thead>");
        boolean odd = true;
        for (FailedResourceDTO rsrc : dto.failedResourceDTOs) {
            StringBuilder sb = new StringBuilder();
            sb.append("${reason} : ").append(this.getErrorText(rsrc.failureReason)).append("\n");
            ServiceReference<?> ref = this.getServiceReference(rsrc.serviceId);
            sb.append("${service.id} : ");
            this.appendServiceLink(sb, rsrc.serviceId);
            sb.append("\n");
            this.appendServiceRanking(sb, ref);
            if (ref != null) {
                sb.append("${bundle} : ");
                this.appendBundleLink(sb, ref.getBundle().getBundleId(), ref.getBundle().getSymbolicName());
                sb.append("\n");
            }
            StringBuilder psb = new StringBuilder();
            for (String p : rsrc.patterns) {
                psb.append(p).append('\n');
            }
            odd = this.printRow(pw, odd, psb.toString(), rsrc.prefix, sb.toString());
        }
        pw.println("</table>");
    }

    private void printErrorPageDetails(PrintWriter pw, ServletContextDTO dto) {
        if (dto.errorPageDTOs.length == 0) {
            return;
        }
        pw.print("<p class=\"statline ui-state-highlight\">${Servlet Context} '");
        pw.print(Encode.forHtmlContent((String)dto.name));
        pw.println("' ${Registered Error Pages}</p>");
        pw.println("<table class=\"nicetable\">");
        pw.println("<thead><tr>");
        pw.println("<th class=\"header\">${Path}</th>");
        pw.println("<th class=\"header\">${Name}</th>");
        pw.println("<th class=\"header\">${Info}</th>");
        pw.println("</tr></thead>");
        boolean odd = true;
        for (ErrorPageDTO ep : dto.errorPageDTOs) {
            StringBuilder sb = new StringBuilder();
            ServiceReference<?> ref = this.getServiceReference(ep.serviceId);
            sb.append("${service.id} : ");
            this.appendServiceLink(sb, ep.serviceId);
            sb.append("\n");
            this.appendServiceRanking(sb, ref);
            sb.append("${async} : ").append(String.valueOf(ep.asyncSupported)).append("\n");
            if (ref != null) {
                sb.append("${bundle} : ");
                this.appendBundleLink(sb, ref.getBundle().getBundleId(), ref.getBundle().getSymbolicName());
                sb.append("\n");
            }
            StringBuilder psb = new StringBuilder();
            for (long p : ep.errorCodes) {
                psb.append(p).append('\n');
            }
            for (String p : ep.exceptions) {
                psb.append(p).append('\n');
            }
            odd = this.printRow(pw, odd, psb.toString(), ep.name, sb.toString());
        }
        pw.println("</table>");
    }

    private void printFailedErrorPageDetails(PrintWriter pw, RuntimeDTO dto) {
        if (dto.failedErrorPageDTOs.length == 0) {
            return;
        }
        pw.print("<p class=\"statline ui-state-highlight\">${Registered Error Pages}</p>");
        pw.println("<table class=\"nicetable\">");
        pw.println("<thead><tr>");
        pw.println("<th class=\"header\">${Path}</th>");
        pw.println("<th class=\"header\">${Name}</th>");
        pw.println("<th class=\"header\">${Info}</th>");
        pw.println("</tr></thead>");
        boolean odd = true;
        for (FailedErrorPageDTO ep : dto.failedErrorPageDTOs) {
            StringBuilder sb = new StringBuilder();
            sb.append("${reason} : ").append(this.getErrorText(ep.failureReason)).append("\n");
            ServiceReference<?> ref = this.getServiceReference(ep.serviceId);
            sb.append("${service.id} : ");
            this.appendServiceLink(sb, ep.serviceId);
            sb.append("\n");
            this.appendServiceRanking(sb, ref);
            sb.append("${async} : ").append(String.valueOf(ep.asyncSupported)).append("\n");
            if (ref != null) {
                sb.append("${bundle} : ");
                this.appendBundleLink(sb, ref.getBundle().getBundleId(), ref.getBundle().getSymbolicName());
                sb.append("\n");
            }
            StringBuilder psb = new StringBuilder();
            for (long p : ep.errorCodes) {
                psb.append(p).append('\n');
            }
            for (String p : ep.exceptions) {
                psb.append(p).append('\n');
            }
            odd = this.printRow(pw, odd, psb.toString(), ep.name, sb.toString());
        }
        pw.println("</table>");
    }

    private void printListenerDetails(PrintWriter pw, ServletContextDTO dto) {
        if (dto.listenerDTOs.length == 0) {
            return;
        }
        pw.print("<p class=\"statline ui-state-highlight\">${Servlet Context} '");
        pw.print(Encode.forHtmlContent((String)dto.name));
        pw.println("' ${Registered Listeners}</p>");
        pw.println("<table class=\"nicetable\">");
        pw.println("<thead><tr>");
        pw.println("<th class=\"header\">${Type}</th>");
        pw.println("<th class=\"header\">${Info}</th>");
        pw.println("</tr></thead>");
        boolean odd = true;
        for (ListenerDTO ep : dto.listenerDTOs) {
            StringBuilder sb = new StringBuilder();
            ServiceReference<?> ref = this.getServiceReference(ep.serviceId);
            sb.append("${service.id} : ");
            this.appendServiceLink(sb, ep.serviceId);
            sb.append("\n");
            this.appendServiceRanking(sb, ref);
            if (ref != null) {
                sb.append("${bundle} : ");
                this.appendBundleLink(sb, ref.getBundle().getBundleId(), ref.getBundle().getSymbolicName());
                sb.append("\n");
            }
            StringBuilder tsb = new StringBuilder();
            for (String t : ep.types) {
                tsb.append(t).append('\n');
            }
            odd = this.printRow(pw, odd, tsb.toString(), sb.toString());
        }
        pw.println("</table>");
    }

    private void printFailedListenerDetails(PrintWriter pw, RuntimeDTO dto) {
        if (dto.failedListenerDTOs.length == 0) {
            return;
        }
        pw.print("<p class=\"statline ui-state-highlight\">${Failed Listeners}</p>");
        pw.println("<table class=\"nicetable\">");
        pw.println("<thead><tr>");
        pw.println("<th class=\"header\">${Type}</th>");
        pw.println("<th class=\"header\">${Info}</th>");
        pw.println("</tr></thead>");
        boolean odd = true;
        for (FailedListenerDTO ep : dto.failedListenerDTOs) {
            StringBuilder sb = new StringBuilder();
            sb.append("${reason} : ").append(this.getErrorText(ep.failureReason)).append("\n");
            ServiceReference<?> ref = this.getServiceReference(ep.serviceId);
            sb.append("${service.id} : ");
            this.appendServiceLink(sb, ep.serviceId);
            sb.append("\n");
            this.appendServiceRanking(sb, ref);
            if (ref != null) {
                sb.append("${bundle} : ");
                this.appendBundleLink(sb, ref.getBundle().getBundleId(), ref.getBundle().getSymbolicName());
                sb.append("\n");
            }
            StringBuilder tsb = new StringBuilder();
            for (String t : ep.types) {
                tsb.append(t).append('\n');
            }
            odd = this.printRow(pw, odd, tsb.toString(), sb.toString());
        }
        pw.println("</table>");
    }
}

