#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2002-2007 Free Software Foundation
#
# FILE:
# Menu.py
#
# DESCRIPTION:
#
# NOTES:
#


from constants import *
from FocusedLabel import FocusedLabel
from Dialog import Dialog
from MenuItem import MenuItem
from Container import *
import sio

class Menu(FocusedLabel):
  def __init__(self,Parent,MenuName,Y,X,DisplayName = "",
               statusBarLink=None, **properties):
    self.maxLengthFixed = 0
    DisplayName = self.__FixDisplay(DisplayName)
    FocusedLabel.__init__(self,Parent,MenuName,Y,X,DisplayName, **properties)
    self.PARENT = Parent
    self.STATUSBARLINK = statusBarLink
    self.SetMethod("CLICK",self.ShowOff)
    self.items = []
    self.maxLength = 0
    self.SetColor(Parent.SCREEN.colors.C_MENUBAR, Parent.SCREEN.colors.C_MENUBAR_FOCUS)

  def Run(self,v1,v2,v3):
    if v1 :
      self.ExecMethod("CLICK", self, None, None)
      if self.EXITFORM:
        return 1
    Container = self.SCREEN;
    global BACKWARDS
    while 1:
      if self.active != 1:
        self.breakUp = 1
      if self.breakUp :
        self.breakUp = 0
        return 0
      ch = Container.GetChar()
      if self.PARENT.BreakOrder(ch) :
        return
      if ch in (Container.TokNextField, Container.TokRightArrow):
        BACKWARDS=0
        return
      elif ch == Container.TokLeftArrow:
        BACKWARDS=1
        return
      elif ch in (Container.TokDownArrow,  Container.TokActivate):
        self.ExecMethod("CLICK", self, None, None)
        if self.EXITFORM:
          self.PARENT.Paint()
          if self.PARENT.__class__ != Container:
            self.PARENT.Refresh(None,None,None)
          return 1
        self.ExecMethod("SYSGOTFOCUS", None, None, None)

  def ShowStatusBarText(self, text):
    try:
      # Voodoo-ery
      self.STATUSBARLINK.STATUSBAR.SetText(self.STATUSBARLINK.STATUSBAR_INDEX, text)
    except (AttributeError, TypeError):
      pass

  def ShowOff(self,arg1, arg2,arg3):
    MenuHeight = len(self.items)
    MenuWidth  = self.maxLength
    X = self.X
    Y = self.Y + 1
    Parent = self.PARENT
    Screen = Parent.SCREEN
    self.myscreen = Screen.CaptureScreen( Y, X, Y + MenuHeight ,
      X + MenuWidth )
    MenuWin = Dialog(Parent, Y, X, Y + MenuHeight, X + MenuWidth )
    MenuWin.SetColor(Screen.colors.C_MENUBAR)
    count = 1
    self.EXITFORM = 0
    for i in range(len(self.items)):
      text = ''
      if self.items[i][0] == -1:
        text = (self.maxLength - 2) * chr(tiHLINE)
      else:
        newTitle = self.items[i][1]
        text = self.__FixDisplay(newTitle)
      item = MenuItem(MenuWin,str(self.items[i][0]),count-1,0,text,
          self.items[i][2])
      item.ITEMID = self.items[i][0]
      count += 1
      item.SetMethod("CLICK",self.ItemSelected)
      item.SetMethod("GOTFOCUS",self.ItemFocused)
      MenuWin.AddControl(item)
      item.DeActivate(self.items[i][3])
##    MenuWin.INSET = 1
    MenuWin.DROPSHADOW=0
    r =MenuWin.RunDialog()
    Parent.Paint()
    Parent.Screen().Refresh()

  def __FixDisplay(self, newTitle):
    erg = newTitle
    if self.maxLengthFixed :
      newLen = len(newTitle)
      oldLen = self.maxLength -  4
      if newLen >= oldLen:
        oldLen -= 3
        oldLen = oldLen / 2
        erg = newTitle[:oldLen] + '...' + newTitle[-oldLen:]
      else:
        erg = newTitle + (oldLen-newLen)*' '
    return erg

  def Finalize(self):
    self.PARENT.AddControl(self)

  def ItemSelected(self,control, arg2,arg3):
    MenuHeight = len(self.items) + 2
    MenuWidth  = self.maxLength
    X = self.X
    Y = self.Y+ 1
    Parent = self.PARENT
    Screen = Parent.SCREEN
#    Screen.RestoreScreen(Y,X, Y + MenuHeight , X + MenuWidth ,
#      self.myscreen )
    self.ShowStatusBarText("")
    if(self.GetMethod("CHOSEN") <> None):
      apply(self.GetMethod("CHOSEN"),(self,control.ITEMID,control.TITLE))

  def ItemFocused(self,control, arg2,arg3):
    assert gDebug(0,'I got that focused feeling!')
    self.ShowStatusBarText(control.DESCRIPTION)
    return 1


  def DeActivateItem(self,itemId,state):
    for i in range(0,len(self.items)):
      if self.items[i][0] == itemId:
        self.items[i][3] = state
        return

  def AddItem(self, itemId, itemCaption, itemDescription = "", initialState = 1):
    self.items.append( [ itemId, itemCaption, itemDescription, initialState ] )
    if not self.maxLengthFixed and self.maxLength < len(itemCaption)+2:
      self.maxLength = len(itemCaption)+2

  def InsertSeperator(self):
    self.items.append( [ -1, '','', 0 ])

  def ChangeTitle(self,newTitle):
    newLen = len(newTitle)
    oldLen = len(self.CAPTION)
    if newLen >= oldLen:
      newTitle = self.__FixDisplay(newTitle)
      self.CAPTION = newTitle[:oldLen]
    else:
      newTitle = newTitle + (oldLen-newLen)*' '
      self.CAPTION = newTitle

  def Clear(self):
    self.items = []

  def GetWidth(self):
    return self.maxLength


