#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2002-2007 Free Software Foundation
#
# FILE:
# DirChooser.py
#
# DESCRIPTION:
#
# NOTES:
#


import os
import string

from constants import *
from MenuBar import MenuBar
from Control import Control
from Button import Button

class DirChooser(Control):
  def __init__(self, Root, Y, X, W, Start, Name="", **properties):
    Control.__init__(self, Root, Name, properties)
    self.X = X
    self.Y = Y
    self.W = int(W)
    self.H = 1
    self.SCREEN = Root
    self.back_button = Button(Root,'backButt',1,1,8,'back')
    self.up_button   = Button(Root,'upButt',1,9,8,'up')
    self.back_button.SetMethod("CLICK",self.Back)
    self.up_button.SetMethod("CLICK",self.Up)
    Root.AddControl(self.back_button)
    Root.AddControl(self.up_button)
    self.back_button.DeActivate(0)
    self.startDir = Start
    self.dir_chooser_bar = MenuBar(Root,1,18)
    self.dir_chooser = self.dir_chooser_bar.NewMenu('dir_chooser', 
      (int(W)-19)*' ')
    self.dir_chooser.maxLengthFixed = 1
    self.dir_chooser.maxLength = W-19
    self.dir_chooser.SetMethod("CHOSEN",self.Chosen)
    self.dir_chooser.Finalize()
    self.dir_entries = {}
    self.lastPath = []
    self.__Scan(Start)
    self.__PathMax = 20

  def Up(self, control, arg2,arg3):
    self.Chosen(None,1,None)

  def Back(self,control,arg2,arg3):
    if len(self.lastPath) != 0:
      self.__Scan(self.lastPath.pop())
    if len(self.lastPath) == 0:
      self.back_button.DeActivate(0)

  def Chosen(self, control, ItemId, arg3):
    if len(self.lastPath) == 0:
      self.lastPath.append(self.dir_entries[0])
      self.back_button.DeActivate(1)
    elif self.lastPath.count(self.dir_entries[0]) == 0:
      if len(self.lastPath) < self.__PathMax:
        self.lastPath.append( self.dir_entries[0])
    self.__Scan(self.dir_entries[ItemId])

  def GetPath(self):
    if len(self.dir_entries) > 0:
      return self.dir_entries[0]
    return None

  def __Scan(self,path):
    if os.access(path, os.R_OK | os.X_OK) and os.path.isdir(path):
      if path != '/':
        self.up_button.DeActivate(1)
      else:
        self.up_button.DeActivate(0)
      count = 0
      self.dir_entries = {}
      self.dir_entries[count] = path
      self.dir_chooser.Clear()
      self.dir_chooser.AddItem(count,path)
      self.dir_chooser.ChangeTitle(path)
      while string.rfind(path,'/') != -1:
        pos = string.rfind(path,'/')
        path = path[:pos]
        count += 1
        set = path
        if set == '':
          set = '/'
        self.dir_chooser.AddItem(count,set)
        self.dir_entries[count] = set

      # add all recently visited paths
      if self.dir_entries.has_key(count):
        count += 1
      for i in range(0,len(self.lastPath)):
        doit = 1
        for j in self.dir_entries.keys():
          if self.dir_entries[j] == self.lastPath[i]:
            doit = 0
        if doit :
          self.dir_entries[count] = self.lastPath[i]
          self.dir_chooser.AddItem(count,self.lastPath[i])
          count += 1
      inform = self.GetMethod("CHANGED")
      if inform != None:
          apply( inform,(self.dir_entries[0],))
      self.dir_chooser.ExecMethod("SYSPAINT",None,None,None)
      self.dir_chooser.ExecMethod("REFRESH",None,None,None)
      return 1
    return 0

  def Paint(self, arg1,arg2,arg3):
    self.SCREEN.Paint()

  def AddPath(self, path, arg1, arg2):
    self.__Scan(path)

  def HasEntries(self):
    return len(self.dir_entries)>0


