/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form;

import java.util.Collection;
import org.apache.wicket.IGenericComponent;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.form.CheckGroup;
import org.apache.wicket.markup.html.form.LabeledWebMarkupContainer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.string.Strings;

public class Check<T>
extends LabeledWebMarkupContainer
implements IGenericComponent<T, Check<T>> {
    private static final long serialVersionUID = 1L;
    private static final String ATTR_DISABLED = "disabled";
    private int uuid = -1;
    private final CheckGroup<T> group;

    public Check(String id) {
        this(id, null, null);
    }

    public Check(String id, IModel<T> model) {
        this(id, model, null);
    }

    public Check(String id, CheckGroup<T> group) {
        this(id, null, group);
    }

    public Check(String id, IModel<T> model, CheckGroup<T> group) {
        super(id, model);
        this.group = group;
        this.setOutputMarkupId(true);
    }

    public String getValue() {
        if (this.uuid < 0) {
            this.uuid = this.getPage().getAutoIndex();
        }
        return "check" + this.uuid;
    }

    protected CheckGroup<T> getGroup() {
        CheckGroup group = this.group;
        if (group == null && (group = this.findParent(CheckGroup.class)) == null) {
            throw new WicketRuntimeException("Check component [" + this.getPath() + "] cannot find its parent CheckGroup");
        }
        return group;
    }

    @Override
    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        this.checkComponentTag(tag, "input");
        this.checkComponentTagAttribute(tag, "type", "checkbox");
        CheckGroup<T> group = this.getGroup();
        String uuid = this.getValue();
        tag.put("name", group.getInputName());
        tag.put("value", uuid);
        Collection collection = (Collection)group.getDefaultModelObject();
        if (collection == null) {
            throw new WicketRuntimeException("CheckGroup [" + group.getPath() + "] contains a null model object, must be an object of type java.util.Collection");
        }
        if (group.hasRawInput()) {
            String raw = group.getRawInput();
            if (!Strings.isEmpty((CharSequence)raw)) {
                String[] values;
                for (String value : values = raw.split(";")) {
                    if (!uuid.equals(value)) continue;
                    tag.put("checked", "checked");
                }
            }
        } else if (collection.contains(this.getDefaultModelObject())) {
            tag.put("checked", "checked");
        }
        if (!(this.isActionAuthorized(ENABLE) && this.isEnabledInHierarchy() && group.isEnabledInHierarchy())) {
            tag.put(ATTR_DISABLED, ATTR_DISABLED);
        }
    }

    @Override
    public Check<T> setLabel(IModel<String> labelModel) {
        super.setLabel(labelModel);
        return this;
    }

    @Override
    protected boolean getStatelessHint() {
        return false;
    }
}

