/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.catalina.Context;
import org.apache.catalina.Globals;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.ClientAbortException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.coyote.ActionCode;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.descriptor.web.ErrorPage;
import org.apache.tomcat.util.res.StringManager;

final class StandardHostValve
extends ValveBase {
    private static final Log log = LogFactory.getLog(StandardHostValve.class);
    private static final StringManager sm = StringManager.getManager(StandardHostValve.class);
    private static final ClassLoader MY_CLASSLOADER = StandardHostValve.class.getClassLoader();
    static final boolean STRICT_SERVLET_COMPLIANCE = Globals.STRICT_SERVLET_COMPLIANCE;
    static final boolean ACCESS_SESSION;

    StandardHostValve() {
        super(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        Context context = request.getContext();
        if (context == null) {
            if (!response.isError()) {
                response.sendError(404);
            }
            return;
        }
        if (request.isAsyncSupported()) {
            request.setAsyncSupported(context.getPipeline().isAsyncSupported());
        }
        boolean asyncAtStart = request.isAsync();
        try {
            block19: {
                context.bind(Globals.IS_SECURITY_ENABLED, MY_CLASSLOADER);
                if (!asyncAtStart && !context.fireRequestInitEvent(request.getRequest())) {
                    return;
                }
                try {
                    if (!response.isErrorReportRequired()) {
                        context.getPipeline().getFirst().invoke(request, response);
                    }
                }
                catch (Throwable t) {
                    ExceptionUtils.handleThrowable(t);
                    this.container.getLogger().error(sm.getString("standardHostValve.exception", request.getRequestURI()), t);
                    if (response.isErrorReportRequired()) break block19;
                    request.setAttribute("javax.servlet.error.exception", t);
                    this.throwable(request, response, t);
                }
            }
            response.setSuspended(false);
            Throwable t = (Throwable)request.getAttribute("javax.servlet.error.exception");
            if (!context.getState().isAvailable()) {
                return;
            }
            if (response.isErrorReportRequired()) {
                AtomicBoolean result = new AtomicBoolean(false);
                response.getCoyoteResponse().action(ActionCode.IS_IO_ALLOWED, result);
                if (result.get()) {
                    if (t != null) {
                        this.throwable(request, response, t);
                    } else {
                        this.status(request, response);
                    }
                }
            }
            if (!request.isAsync() && !asyncAtStart) {
                context.fireRequestDestroyEvent(request.getRequest());
            }
        }
        finally {
            if (ACCESS_SESSION) {
                request.getSession(false);
            }
            context.unbind(Globals.IS_SECURITY_ENABLED, MY_CLASSLOADER);
        }
    }

    private void status(Request request, Response response) {
        int statusCode = response.getStatus();
        Context context = request.getContext();
        if (context == null) {
            return;
        }
        if (!response.isError()) {
            return;
        }
        ErrorPage errorPage = context.findErrorPage(statusCode);
        if (errorPage == null) {
            errorPage = context.findErrorPage(0);
        }
        if (errorPage != null && response.isErrorReportRequired()) {
            response.setAppCommitted(false);
            this.setRequestErrorAttributes(request, statusCode, null, response.getMessage(), null, errorPage.getLocation());
            if (this.custom(request, response, errorPage)) {
                response.setErrorReported();
                try {
                    response.finishResponse();
                }
                catch (ClientAbortException clientAbortException) {
                }
                catch (IOException ioe) {
                    this.container.getLogger().warn(sm.getString("standardHostValve.exception", errorPage), ioe);
                }
            }
        }
    }

    protected void throwable(Request request, Response response, Throwable throwable) {
        Context context = request.getContext();
        if (context == null) {
            return;
        }
        Throwable realError = throwable;
        if (realError instanceof ServletException && (realError = ((ServletException)realError).getRootCause()) == null) {
            realError = throwable;
        }
        if (realError instanceof ClientAbortException) {
            if (log.isDebugEnabled()) {
                log.debug(sm.getString("standardHost.clientAbort", realError.getCause().getMessage()));
            }
            return;
        }
        ErrorPage errorPage = context.findErrorPage(throwable);
        if (errorPage == null && realError != throwable) {
            errorPage = context.findErrorPage(realError);
        }
        if (errorPage != null) {
            if (response.setErrorReported()) {
                response.setAppCommitted(false);
                this.setRequestErrorAttributes(request, 500, realError.getClass(), throwable.getMessage(), realError, errorPage.getLocation());
                if (this.custom(request, response, errorPage)) {
                    try {
                        response.finishResponse();
                    }
                    catch (IOException ioe) {
                        this.container.getLogger().warn(sm.getString("standardHostValve.exception", errorPage), ioe);
                    }
                }
            }
        } else {
            if (response.getStatus() < 400) {
                response.setStatus(500);
            }
            response.setError();
            this.status(request, response);
        }
    }

    private void setRequestErrorAttributes(Request request, int statusCode, Class<?> exceptionType, String message, Throwable exception, String location) {
        request.setAttribute("javax.servlet.error.status_code", statusCode);
        if (exceptionType != null) {
            request.setAttribute("javax.servlet.error.exception_type", exceptionType);
        }
        if (message == null) {
            request.setAttribute("javax.servlet.error.message", "");
        } else {
            request.setAttribute("javax.servlet.error.message", message);
        }
        if (exception != null) {
            request.setAttribute("javax.servlet.error.exception", exception);
        }
        request.setAttribute("javax.servlet.error.request_uri", request.getRequestURI());
        Wrapper wrapper = request.getWrapper();
        if (wrapper != null) {
            request.setAttribute("javax.servlet.error.servlet_name", wrapper.getName());
        }
        request.setAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH", location);
        request.setAttribute("org.apache.catalina.core.DISPATCHER_TYPE", (Object)DispatcherType.ERROR);
    }

    private boolean custom(Request request, Response response, ErrorPage errorPage) {
        if (this.container.getLogger().isTraceEnabled()) {
            this.container.getLogger().trace("Processing " + errorPage);
        }
        try {
            ServletContext servletContext = request.getContext().getServletContext();
            RequestDispatcher rd = servletContext.getRequestDispatcher(errorPage.getLocation());
            if (rd == null) {
                this.container.getLogger().error(sm.getString("standardHostValve.customStatusFailed", errorPage.getLocation()));
                return false;
            }
            if (response.isCommitted()) {
                rd.include(request.getRequest(), response.getResponse());
                try {
                    response.flushBuffer();
                }
                catch (Throwable t) {
                    ExceptionUtils.handleThrowable(t);
                }
                response.getCoyoteResponse().action(ActionCode.CLOSE_NOW, request.getAttribute("javax.servlet.error.exception"));
            } else {
                response.resetBuffer(true);
                response.setContentLength(-1);
                rd.forward(request.getRequest(), response.getResponse());
                response.setSuspended(false);
            }
            return true;
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            this.container.getLogger().error(sm.getString("standardHostValve.exception", errorPage), t);
            return false;
        }
    }

    static {
        String accessSession = System.getProperty("org.apache.catalina.core.StandardHostValve.ACCESS_SESSION");
        ACCESS_SESSION = accessSession == null ? STRICT_SERVLET_COMPLIANCE : Boolean.parseBoolean(accessSession);
    }
}

