/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.Collections;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.ScalarMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;

public final class ReplaceGlobalStep<S, E>
extends ScalarMapStep<S, E> {
    private final String oldChar;
    private final String newChar;

    public ReplaceGlobalStep(Traversal.Admin traversal, String oldChar, String newChar) {
        super(traversal);
        this.oldChar = oldChar;
        this.newChar = newChar;
    }

    @Override
    protected E map(Traverser.Admin<S> traverser) {
        Object item = traverser.get();
        if (null != item && !(item instanceof String)) {
            throw new IllegalArgumentException(String.format("The replace() step can only take string as argument, encountered %s.", item.getClass()));
        }
        return (E)(null == item ? null : StringUtils.replace((String)((String)item), (String)this.oldChar, (String)this.newChar));
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return Collections.singleton(TraverserRequirement.OBJECT);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (null != this.oldChar ? this.oldChar.hashCode() : 0);
        result = 31 * result + (null != this.newChar ? this.newChar.hashCode() : 0);
        return result;
    }
}

