/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services.assets;

import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.tapestry5.commons.Resource;
import org.apache.tapestry5.http.services.Request;
import org.apache.tapestry5.http.services.Response;
import org.apache.tapestry5.internal.services.ResourceStreamer;
import org.apache.tapestry5.internal.services.assets.ChecksumPath;
import org.apache.tapestry5.services.assets.AssetRequestHandler;

public class ContextAssetRequestHandler
implements AssetRequestHandler {
    private final ResourceStreamer resourceStreamer;
    private final Resource rootContextResource;
    private final Pattern illegal = Pattern.compile("^([\\\\/]*((web|meta)-inf.*)|(.*\\.tml$))", 2);

    public ContextAssetRequestHandler(ResourceStreamer resourceStreamer, Resource rootContextResource) {
        this.resourceStreamer = resourceStreamer;
        this.rootContextResource = rootContextResource;
    }

    @Override
    public boolean handleAssetRequest(Request request, Response response, String extraPath) throws IOException {
        ChecksumPath path = new ChecksumPath(this.resourceStreamer, null, extraPath);
        if (this.illegal.matcher(path.resourcePath).matches()) {
            return false;
        }
        return path.stream(this.rootContextResource.forFile(path.resourcePath));
    }
}

