/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import net.sf.jasperreports.engine.fill.JRVirtualizationContext;
import net.sf.jasperreports.engine.fill.VirtualizerStore;
import net.sf.jasperreports.engine.fill.VirtualizerStoreFactory;
import net.sf.jasperreports.engine.util.JRSwapFile;
import net.sf.jasperreports.engine.util.StreamCompression;
import net.sf.jasperreports.engine.util.SwapFileVirtualizerStore;

public class SwapFileVirtualizerStoreFactory
implements VirtualizerStoreFactory {
    private String directory = System.getProperty("java.io.tmpdir");
    private int blockSize = 4096;
    private int minGrowCount = 20;
    private StreamCompression compression;

    @Override
    public VirtualizerStore createStore(JRVirtualizationContext virtualizationContext) {
        JRSwapFile swapFile = new JRSwapFile(this.directory, this.blockSize, this.minGrowCount);
        return new SwapFileVirtualizerStore(swapFile, true, this.compression);
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public void setBlockSize(int blockSize) {
        this.blockSize = blockSize;
    }

    public int getMinGrowCount() {
        return this.minGrowCount;
    }

    public void setMinGrowCount(int minGrowCount) {
        this.minGrowCount = minGrowCount;
    }

    public StreamCompression getCompression() {
        return this.compression;
    }

    public void setCompression(StreamCompression compression) {
        this.compression = compression;
    }
}

