/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.maven.mojos.apis;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.sling.feature.maven.mojos.apis.spi.Source;
import org.codehaus.plexus.archiver.util.DefaultFileSet;
import org.codehaus.plexus.util.DirectoryScanner;

public class DirectorySource
implements Source {
    private final DefaultFileSet fileSet;

    public DirectorySource(DefaultFileSet set) {
        this.fileSet = set;
    }

    @Override
    public File getBaseDirectory() {
        return this.fileSet.getDirectory();
    }

    @Override
    public List<File> getFiles() {
        String[] exc;
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(this.fileSet.getDirectory());
        String[] inc = this.fileSet.getIncludes();
        if (inc != null && inc.length > 0) {
            ds.setIncludes(inc);
        }
        if ((exc = this.fileSet.getExcludes()) != null && exc.length > 0) {
            ds.setExcludes(exc);
        }
        if (this.fileSet.isUsingDefaultExcludes()) {
            ds.addDefaultExcludes();
        }
        ds.setCaseSensitive(this.fileSet.isCaseSensitive());
        ds.setFollowSymlinks(false);
        ds.scan();
        ArrayList<File> result = new ArrayList<File>();
        for (String file : ds.getIncludedFiles()) {
            result.add(new File(this.fileSet.getDirectory(), file));
        }
        return result;
    }
}

