/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.core.impl.bundled;

import java.io.Writer;
import org.slf4j.Logger;

class LogWriter
extends Writer {
    private final Logger logger;
    private final StringBuilder lineBuffer;

    LogWriter(Logger logger) {
        this.logger = logger;
        this.lineBuffer = new StringBuilder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int c) {
        if (c == 10 || c == 13) {
            this.flush();
        } else {
            StringBuilder stringBuilder = this.lineBuffer;
            synchronized (stringBuilder) {
                this.lineBuffer.append((char)c);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] cbuf, int off, int len) {
        int i = off;
        int n = 0;
        while (n < len) {
            char c = cbuf[i];
            if (c == '\n' || c == '\r') {
                int subLen = i - off;
                if (subLen > 0) {
                    StringBuilder stringBuilder = this.lineBuffer;
                    synchronized (stringBuilder) {
                        this.lineBuffer.append(cbuf, off, subLen);
                    }
                }
                this.flush();
                off = i + 1;
            }
            ++n;
            ++i;
        }
        if (off < i) {
            StringBuilder stringBuilder = this.lineBuffer;
            synchronized (stringBuilder) {
                this.lineBuffer.append(cbuf, off, i - off);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        String message;
        StringBuilder stringBuilder = this.lineBuffer;
        synchronized (stringBuilder) {
            if (this.lineBuffer.length() == 0) {
                return;
            }
            message = this.lineBuffer.toString();
            this.lineBuffer.setLength(0);
        }
        this.logger.error(message);
    }

    @Override
    public void close() {
        this.flush();
    }
}

