/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl.mapping;

import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.UnaryOperator;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.mapping.ResourceMapper;
import org.apache.sling.resourceresolver.impl.JcrNamespaceMangler;
import org.apache.sling.resourceresolver.impl.ResourceResolverImpl;
import org.apache.sling.resourceresolver.impl.helper.ResourceDecoratorTracker;
import org.apache.sling.resourceresolver.impl.helper.URI;
import org.apache.sling.resourceresolver.impl.helper.URIException;
import org.apache.sling.resourceresolver.impl.mapping.MapEntriesHandler;
import org.apache.sling.resourceresolver.impl.mapping.MapEntry;
import org.apache.sling.resourceresolver.impl.mapping.PathGenerator;
import org.apache.sling.resourceresolver.impl.params.ParsedParameters;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceMapperImpl
implements ResourceMapper {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ResourceResolverImpl resolver;
    private final ResourceDecoratorTracker resourceDecorator;
    private final MapEntriesHandler mapEntries;
    private final Object namespaceMangler;

    public ResourceMapperImpl(ResourceResolverImpl resolver, ResourceDecoratorTracker resourceDecorator, MapEntriesHandler mapEntries, Object namespaceMangler) {
        this.resolver = resolver;
        this.resourceDecorator = resourceDecorator;
        this.mapEntries = mapEntries;
        this.namespaceMangler = namespaceMangler;
    }

    public String getMapping(String resourcePath) {
        return this.getMapping(resourcePath, (HttpServletRequest)null);
    }

    public String getMapping(String resourcePath, HttpServletRequest request) {
        Collection<String> mappings = this.getAllMappings(resourcePath, request);
        if (mappings.isEmpty()) {
            throw new IllegalArgumentException("No mapping returned by getAllMappings(...)");
        }
        return mappings.iterator().next();
    }

    public String getMapping(String resourcePath, javax.servlet.http.HttpServletRequest request) {
        Collection<String> mappings = this.getAllMappings(resourcePath, request);
        if (mappings.isEmpty()) {
            throw new IllegalArgumentException("No mapping returned by getAllMappings(...)");
        }
        return mappings.iterator().next();
    }

    public Collection<String> getAllMappings(String resourcePath) {
        return this.getAllMappings(resourcePath, (HttpServletRequest)null);
    }

    public Collection<String> getAllMappings(String resourcePath, HttpServletRequest request) {
        this.resolver.checkClosed();
        RequestContext requestContext = new RequestContext(request, resourcePath);
        return this.getAllMappingsInternal(resourcePath, requestContext);
    }

    public Collection<String> getAllMappings(String resourcePath, javax.servlet.http.HttpServletRequest request) {
        this.resolver.checkClosed();
        RequestContext requestContext = new RequestContext(request, resourcePath);
        return this.getAllMappingsInternal(resourcePath, requestContext);
    }

    private Collection<String> getAllMappingsInternal(String resourcePath, RequestContext requestContext) {
        String mappedPath;
        String fragmentQuery;
        ArrayList<String> mappings = new ArrayList<String>();
        int fragmentQueryMark = resourcePath.indexOf(35);
        if (fragmentQueryMark < 0) {
            fragmentQueryMark = resourcePath.indexOf(63);
        }
        if (fragmentQueryMark >= 0) {
            fragmentQuery = resourcePath.substring(fragmentQueryMark);
            mappedPath = resourcePath.substring(0, fragmentQueryMark);
            this.logger.debug("map: Splitting resource path '{}' into '{}' and '{}'", new Object[]{resourcePath, mappedPath, fragmentQuery});
        } else {
            fragmentQuery = null;
            mappedPath = resourcePath;
        }
        ParsedParameters parsed = new ParsedParameters(mappedPath);
        this.populateMappingsFromMapEntries(mappings, Collections.singletonList(mappedPath), requestContext);
        Resource nonDecoratedResource = this.resolver.resolveInternal(parsed.getRawPath(), parsed.getParameters());
        if (nonDecoratedResource != null) {
            List<String> aliases = this.loadAliasesIfApplicable(nonDecoratedResource);
            Collections.reverse(aliases);
            mappings.addAll(aliases);
            this.populateMappingsFromMapEntries(mappings, aliases, requestContext);
        }
        if (!mappedPath.isEmpty() && !mappings.contains(mappedPath)) {
            mappings.add(0, mappedPath);
        }
        List vanityPaths = this.mapEntries.getVanityPathMappings().getOrDefault(mappedPath, Collections.emptyList());
        mappings.addAll(0, vanityPaths);
        if (mappings.isEmpty()) {
            mappings.add(nonDecoratedResource != null ? nonDecoratedResource.getPath() : "/");
        }
        mappings.replaceAll(new ApplyContextPath(requestContext));
        if (fragmentQuery != null) {
            mappings.replaceAll(path -> path.concat(fragmentQuery));
        }
        if (this.logger.isDebugEnabled()) {
            mappings.forEach(path -> this.logger.debug("map: Returning URL {} as mapping for path {}", path, (Object)resourcePath));
        }
        Collections.reverse(mappings);
        return new LinkedHashSet<String>(mappings);
    }

    private List<String> loadAliasesIfApplicable(Resource nonDecoratedResource) {
        Resource res = this.resourceDecorator.decorate(nonDecoratedResource);
        String resolutionPathInfo = res.getResourceMetadata().getResolutionPathInfo();
        this.logger.debug("map: Path maps to resource {} with path info {}", (Object)res, (Object)resolutionPathInfo);
        PathGenerator pathBuilder = new PathGenerator();
        pathBuilder.setResolutionPathInfo(resolutionPathInfo);
        this.resolveAliases(res, pathBuilder);
        List<String> mappedPaths = pathBuilder.generatePaths();
        mappedPaths.remove(nonDecoratedResource.getPath());
        this.logger.debug("map: Alias mapping resolves to paths {}", mappedPaths);
        return mappedPaths;
    }

    private void resolveAliases(@NotNull Resource resource, @NotNull PathGenerator pathGenerator) {
        Resource current = resource;
        String path = current.getPath();
        while (path != null && !"/".equals(path)) {
            String name = ResourceUtil.getName((String)path);
            List<String> aliases = current == null || name.equals("jcr:content") ? Collections.emptyList() : this.readAliases(current);
            pathGenerator.insertSegment(aliases, name);
            current = current != null ? current.getParent() : null;
            path = ResourceUtil.getParent((String)path);
        }
    }

    @NotNull
    private Collection<String> readAliases(@NotNull Resource resource) {
        Resource parent = resource.getParent();
        if (parent == null) {
            return Collections.emptyList();
        }
        return this.mapEntries.getAliasMap(parent).getOrDefault(resource.getName(), Collections.emptyList());
    }

    private void populateMappingsFromMapEntries(List<String> mappings, List<String> mappedPathList, RequestContext requestContext) {
        boolean mappedPathIsUrl = false;
        block0: for (String mappedPath : mappedPathList) {
            for (MapEntry mapEntry : this.mapEntries.getMapMaps()) {
                String[] mappedPaths = mapEntry.replace(mappedPath);
                if (mappedPaths == null) continue;
                this.logger.debug("map: Match for Entry {}", (Object)mapEntry);
                boolean bl = mappedPathIsUrl = !mapEntry.isInternal();
                if (mappedPathIsUrl && requestContext.hasUri()) {
                    mappedPath = null;
                    for (String candidate : mappedPaths) {
                        if (candidate.startsWith(requestContext.getUri())) {
                            mappedPath = candidate.substring(requestContext.getUri().length() - 1);
                            mappedPathIsUrl = false;
                            this.logger.debug("map: Found host specific mapping {} resolving to {}", (Object)candidate, (Object)mappedPath);
                            break;
                        }
                        if (!candidate.startsWith(requestContext.getSchemeWithPrefix()) || mappedPath != null) continue;
                        mappedPath = candidate;
                    }
                    if (mappedPath == null) {
                        mappedPath = mappedPaths[0];
                    }
                } else {
                    mappedPath = mappedPaths[0];
                }
                this.logger.debug("map: MapEntry {} matches, mapped path is {}", (Object)mapEntry, (Object)mappedPath);
                mappings.add(mappedPath);
                continue block0;
            }
        }
    }

    private class RequestContext {
        private final String uri;
        private final String schemeWithPrefix;
        private final String contextPath;

        private RequestContext(HttpServletRequest request, String resourcePath) {
            if (request != null) {
                this.uri = MapEntry.getURI(request.getScheme(), request.getServerName(), request.getServerPort(), "/");
                this.schemeWithPrefix = request.getScheme().concat("://");
                ResourceMapperImpl.this.logger.debug("map: Mapping path {} for {} (at least with scheme prefix {})", new Object[]{resourcePath, this.uri, this.schemeWithPrefix});
            } else {
                this.uri = null;
                this.schemeWithPrefix = null;
                ResourceMapperImpl.this.logger.debug("map: Mapping path {} for default", (Object)resourcePath);
            }
            this.contextPath = request == null ? null : request.getContextPath();
        }

        private RequestContext(javax.servlet.http.HttpServletRequest request, String resourcePath) {
            if (request != null) {
                this.uri = MapEntry.getURI(request.getScheme(), request.getServerName(), request.getServerPort(), "/");
                this.schemeWithPrefix = request.getScheme().concat("://");
                ResourceMapperImpl.this.logger.debug("map: Mapping path {} for {} (at least with scheme prefix {})", new Object[]{resourcePath, this.uri, this.schemeWithPrefix});
            } else {
                this.uri = null;
                this.schemeWithPrefix = null;
                ResourceMapperImpl.this.logger.debug("map: Mapping path {} for default", (Object)resourcePath);
            }
            this.contextPath = request == null ? null : request.getContextPath();
        }

        public String getUri() {
            return this.uri;
        }

        public String getSchemeWithPrefix() {
            return this.schemeWithPrefix;
        }

        public boolean hasUri() {
            return this.uri != null && this.schemeWithPrefix != null;
        }

        public String getContextPath() {
            return this.contextPath;
        }
    }

    private class ApplyContextPath
    implements UnaryOperator<String> {
        private final RequestContext ctx;

        private ApplyContextPath(RequestContext ctx) {
            this.ctx = ctx;
        }

        @Override
        public String apply(String path) {
            String mappedPath = path;
            try {
                URI uri = new URI(path, false);
                path = this.mangleNamespaces(uri.getPath() == null ? "" : uri.getPath());
                if (this.ctx.getContextPath() != null && this.ctx.getContextPath().length() > 0) {
                    path = this.ctx.getContextPath().concat(path);
                }
                uri.setPath(path);
                mappedPath = uri.toString();
            }
            catch (URIException e) {
                ResourceMapperImpl.this.logger.warn("map: Unable to mangle namespaces for " + mappedPath + " returning unmangled", (Throwable)((Object)e));
            }
            return mappedPath;
        }

        private String mangleNamespaces(String absPath) {
            if (absPath != null && ResourceMapperImpl.this.namespaceMangler != null && ResourceMapperImpl.this.namespaceMangler instanceof JcrNamespaceMangler) {
                absPath = ((JcrNamespaceMangler)ResourceMapperImpl.this.namespaceMangler).mangleNamespaces(ResourceMapperImpl.this.resolver, ResourceMapperImpl.this.logger, absPath);
            }
            return absPath;
        }
    }
}

