/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.analyser.extensions;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.StringJoiner;
import java.util.jar.JarFile;
import org.apache.commons.lang3.SystemUtils;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.ExecutionEnvironmentExtension;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.ExtensionState;
import org.apache.sling.feature.ExtensionType;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.analyser.extensions.AnalyserMetaDataExtension;
import org.apache.sling.feature.builder.HandlerContext;
import org.apache.sling.feature.builder.PostProcessHandler;
import org.apache.sling.feature.impl.felix.utils.resource.ResourceUtils;
import org.apache.sling.feature.io.IOUtils;
import org.apache.sling.feature.scanner.BundleDescriptor;
import org.apache.sling.feature.scanner.PackageInfo;
import org.apache.sling.feature.scanner.impl.SystemBundleDescriptor;
import org.apache.sling.feature.scanner.spi.FrameworkScanner;
import org.osgi.framework.Version;
import org.osgi.resource.Capability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyserMetaDataHandler
implements PostProcessHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AnalyserMetaDataHandler.class);

    public void postProcess(HandlerContext handlerContext, Feature feature, Extension extension) {
        if ("analyser-metadata".equals(extension.getName())) {
            LOG.debug("Handling analyser-metadata extension {}", (Object)extension);
            JsonObject extensionJSONStructure = extension.getJSONStructure().asJsonObject();
            JsonObjectBuilder result = Json.createObjectBuilder();
            HashMap directEntries = new HashMap();
            LinkedHashMap wildcardEntries = new LinkedHashMap();
            JsonObject[] systemBundleHolder = new JsonObject[1];
            extensionJSONStructure.entrySet().forEach(entry -> {
                if (((String)entry.getKey()).contains("*")) {
                    wildcardEntries.put((String)entry.getKey(), (JsonValue)entry.getValue());
                } else if (((String)entry.getKey()).equals(AnalyserMetaDataExtension.SYSTEM_BUNDLE_KEY)) {
                    systemBundleHolder[0] = ((JsonValue)entry.getValue()).asJsonObject();
                } else {
                    directEntries.put((String)entry.getKey(), (JsonValue)entry.getValue());
                }
            });
            feature.getBundles().stream().forEach(bundle -> this.findFirst(directEntries, wildcardEntries, bundle.getId()).ifPresent(json -> {
                if (this.nullManifest((JsonObject)json)) {
                    JsonObjectBuilder wrapper = Json.createObjectBuilder((JsonObject)json);
                    wrapper.remove("manifest");
                    result.add(bundle.getId().toMvnId(), wrapper);
                } else if (this.noManifest((JsonObject)json)) {
                    JsonObjectBuilder wrapper = Json.createObjectBuilder((JsonObject)json);
                    this.getManifest(handlerContext, bundle.getId()).ifPresent(manifest -> wrapper.add("manifest", (JsonValue)manifest));
                    result.add(bundle.getId().toMvnId(), wrapper);
                } else {
                    result.add(bundle.getId().toMvnId(), (JsonValue)json);
                }
            }));
            if (JsonValue.EMPTY_JSON_OBJECT.equals((Object)systemBundleHolder[0])) {
                JsonObject systemBundle = systemBundleHolder[0];
                try {
                    ExecutionEnvironmentExtension executionEnv = ExecutionEnvironmentExtension.getExecutionEnvironmentExtension((Feature)feature);
                    if (executionEnv != null) {
                        ArtifactId frameworkId = executionEnv.getFramework().getId();
                        if (executionEnv.getJavaVersion() == null) {
                            LOG.warn("No java version set in execution environment extension, skipping version validation");
                        } else {
                            Version requiredJavaVersion = executionEnv.getJavaVersion();
                            Version currentJavaVersion = new Version(SystemUtils.JAVA_VERSION);
                            if (requiredJavaVersion.getMajor() != currentJavaVersion.getMajor()) {
                                throw new IllegalStateException("Execution environment requires Java " + requiredJavaVersion.getMajor() + ", but running on " + currentJavaVersion.getMajor() + ". Aborting.");
                            }
                        }
                        FrameworkScanner scanner = ServiceLoader.load(FrameworkScanner.class).iterator().next();
                        BundleDescriptor fw = scanner.scan(frameworkId, feature.getFrameworkProperties(), handlerContext.getArtifactProvider());
                        JsonObjectBuilder wrapper = Json.createObjectBuilder((JsonObject)systemBundle);
                        JsonObjectBuilder manifest = Json.createObjectBuilder();
                        manifest.add("Provide-Capability", AnalyserMetaDataHandler.capabilitiesToString(fw.getCapabilities()));
                        manifest.add("Export-Package", AnalyserMetaDataHandler.exportedPackagesToString(fw.getExportedPackages()));
                        wrapper.add("manifest", manifest);
                        wrapper.add("artifactId", frameworkId.toMvnId());
                        wrapper.add("scannerCacheKey", SystemBundleDescriptor.createCacheKey(frameworkId, feature.getFrameworkProperties()));
                        result.add(AnalyserMetaDataExtension.SYSTEM_BUNDLE_KEY, wrapper);
                    }
                    LOG.warn("No execution environment found, not creating framework capabilities");
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            } else if (systemBundleHolder[0] != null) {
                result.add(AnalyserMetaDataExtension.SYSTEM_BUNDLE_KEY, (JsonValue)systemBundleHolder[0]);
            }
            feature.getExtensions().remove((Object)extension);
            Extension newEx = new Extension(ExtensionType.JSON, extension.getName(), ExtensionState.OPTIONAL);
            newEx.setJSONStructure((JsonStructure)result.build());
            feature.getExtensions().add((Object)newEx);
        }
    }

    private static String exportedPackagesToString(Set<PackageInfo> exportedPackages) {
        StringJoiner joiner = new StringJoiner(",");
        for (PackageInfo packageInfo : exportedPackages) {
            joiner.add(packageInfo.getName() + ";version=" + packageInfo.getVersion());
        }
        return joiner.toString();
    }

    private static String capabilitiesToString(Set<Capability> capabilities) {
        StringJoiner joiner = new StringJoiner(",");
        for (Capability c : capabilities) {
            joiner.add(ResourceUtils.toString(null, (String)c.getNamespace(), (Map)c.getAttributes(), (Map)c.getDirectives()));
        }
        return joiner.toString();
    }

    private boolean noManifest(JsonObject object) {
        return this.manifest(object, null) && !object.getBoolean("no-manifest", false);
    }

    private boolean nullManifest(JsonObject object) {
        return this.manifest(object, JsonValue.NULL);
    }

    private boolean manifest(JsonObject object, Object match) {
        return object.get((Object)"manifest") == match;
    }

    private Optional<JsonObject> findFirst(Map<String, JsonValue> directValues, Map<String, JsonValue> wildcardValues, ArtifactId bundle) {
        JsonValue direct = directValues.get(bundle.toMvnId());
        if (direct != null && direct != JsonValue.NULL) {
            return Optional.of(direct.asJsonObject());
        }
        return wildcardValues.entrySet().stream().filter(entry -> bundle.toMvnId().matches((String)entry.getKey())).filter(entry -> entry.getValue() != JsonValue.NULL).map(entry -> ((JsonValue)entry.getValue()).asJsonObject()).findFirst();
    }

    private Optional<JsonObject> getManifest(HandlerContext handlerContext, ArtifactId bundle) {
        Optional<JsonObject> optional;
        block8: {
            URL url = handlerContext.getArtifactProvider().provide(bundle);
            JarFile jarFile = IOUtils.getJarFileFromURL((URL)url, (boolean)false, null);
            try {
                optional = Optional.ofNullable(jarFile.getManifest()).map(manifest -> {
                    JsonObjectBuilder manifestBuilder = Json.createObjectBuilder();
                    manifest.getMainAttributes().entrySet().stream().forEachOrdered(entry -> manifestBuilder.add(entry.getKey().toString(), (String)entry.getValue()));
                    return manifestBuilder.build();
                });
                if (jarFile == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jarFile != null) {
                        try {
                            jarFile.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    LOG.error("Unable to parse manifest of: " + bundle, (Throwable)ex);
                    throw new UncheckedIOException(ex);
                }
            }
            jarFile.close();
        }
        return optional;
    }
}

