/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.caconfig.resource.impl.util;

import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;

public final class MapUtil {
    private MapUtil() {
    }

    public static final String traceOutput(Map<String, Object> properties) {
        TreeSet<String> propertyNames = new TreeSet<String>(properties.keySet());
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        Iterator propertyNameIterator = propertyNames.iterator();
        while (propertyNameIterator.hasNext()) {
            String propertyName = (String)propertyNameIterator.next();
            sb.append(propertyName).append(": ");
            MapUtil.appendValue(sb, properties.get(propertyName));
            if (!propertyNameIterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    private static void appendValue(StringBuilder sb, Object value) {
        if (value == null) {
            sb.append("null");
        } else if (value.getClass().isArray()) {
            sb.append("[");
            for (int i = 0; i < Array.getLength(value); ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                MapUtil.appendValue(sb, Array.get(value, i));
            }
            sb.append("]");
        } else if (value instanceof String) {
            sb.append("'").append(value.toString()).append("'");
        } else {
            sb.append(value.toString());
        }
    }
}

