/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.provider.producer;

import io.swagger.v3.oas.models.OpenAPI;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.config.BootStrapProperties;
import org.apache.servicecomb.core.ProducerProvider;
import org.apache.servicecomb.core.SCBEngine;
import org.apache.servicecomb.core.definition.MicroserviceMeta;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.core.definition.SchemaMeta;
import org.apache.servicecomb.core.provider.producer.ProducerMeta;
import org.apache.servicecomb.foundation.common.utils.ClassLoaderScopeContext;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.apache.servicecomb.swagger.SwaggerUtils;
import org.apache.servicecomb.swagger.engine.SwaggerProducer;
import org.apache.servicecomb.swagger.engine.SwaggerProducerOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class ProducerProviderManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProducerProviderManager.class);
    private final List<ProducerProvider> producerProviderList = new ArrayList<ProducerProvider>(SPIServiceUtils.getOrLoadSortedService(ProducerProvider.class));
    private final SCBEngine scbEngine;
    private final List<ProducerMeta> producerMetas = new ArrayList<ProducerMeta>();

    public ProducerProviderManager(SCBEngine scbEngine) {
        this.scbEngine = scbEngine;
    }

    public List<ProducerProvider> getProducerProviderList() {
        return this.producerProviderList;
    }

    public void init() {
        this.registerProducerMetas(this.producerMetas);
        for (ProducerProvider provider : this.producerProviderList) {
            List<ProducerMeta> producerMetas = provider.init();
            if (producerMetas == null) {
                LOGGER.warn("ProducerProvider {} not provide any producer.", (Object)provider.getClass().getName());
                continue;
            }
            this.registerProducerMetas(producerMetas);
        }
    }

    public void addProducerMeta(String schemaId, Object instance) {
        this.addProducerMeta(new ProducerMeta(schemaId, instance));
    }

    public void addProducerMeta(ProducerMeta producerMeta) {
        this.producerMetas.add(producerMeta);
    }

    private void registerProducerMetas(List<ProducerMeta> producerMetas) {
        for (ProducerMeta producerMeta : producerMetas) {
            this.registerSchema(producerMeta.getSchemaId(), producerMeta.getSchemaInterface(), producerMeta.getInstance());
        }
    }

    public SchemaMeta registerSchema(String schemaId, Object instance) {
        return this.registerSchema(schemaId, null, instance);
    }

    public SchemaMeta registerSchema(String schemaId, Class<?> schemaInterface, Object instance) {
        MicroserviceMeta producerMicroserviceMeta = this.scbEngine.getProducerMicroserviceMeta();
        SwaggerProducer swaggerProducer = this.scbEngine.getSwaggerEnvironment().createProducer(instance, schemaInterface);
        OpenAPI swagger = swaggerProducer.getSwagger();
        this.registerUrlPrefixToSwagger(swagger);
        this.scbEngine.getOpenAPIRegistryManager().registerOpenAPI(BootStrapProperties.readApplication((Environment)this.scbEngine.getEnvironment()), BootStrapProperties.readServiceName((Environment)this.scbEngine.getEnvironment()), schemaId, swagger);
        SchemaMeta schemaMeta = producerMicroserviceMeta.registerSchemaMeta(schemaId, swagger);
        schemaMeta.putExtData("scb_swagger-producer", swaggerProducer);
        Executor reactiveExecutor = this.scbEngine.getExecutorManager().findExecutorById("servicecomb.executor.reactive");
        for (SwaggerProducerOperation producerOperation : swaggerProducer.getAllOperations()) {
            OperationMeta operationMeta = schemaMeta.ensureFindOperation(producerOperation.getOperationId());
            operationMeta.setSwaggerProducerOperation(producerOperation);
            if (!CompletableFuture.class.equals(producerOperation.getProducerMethod().getReturnType())) continue;
            operationMeta.setExecutor(this.scbEngine.getExecutorManager().findExecutor(operationMeta, reactiveExecutor));
        }
        return schemaMeta;
    }

    private void registerUrlPrefixToSwagger(OpenAPI swagger) {
        String urlPrefix = ClassLoaderScopeContext.getClassLoaderScopeProperty((String)"urlPrefix");
        if (!StringUtils.isEmpty((CharSequence)urlPrefix) && !SwaggerUtils.getBasePath((OpenAPI)swagger).startsWith(urlPrefix) && ((Boolean)this.scbEngine.getEnvironment().getProperty("servicecomb.registry.registerUrlPrefix", Boolean.TYPE, (Object)false)).booleanValue()) {
            LOGGER.info("Add swagger base path prefix for {} with {}", (Object)SwaggerUtils.getBasePath((OpenAPI)swagger), (Object)urlPrefix);
            SwaggerUtils.setBasePath((OpenAPI)swagger, (String)(urlPrefix + SwaggerUtils.getBasePath((OpenAPI)swagger)));
        }
    }
}

