/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.filter.impl;

import jakarta.ws.rs.core.Response;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.filter.AbstractFilter;
import org.apache.servicecomb.core.filter.FilterNode;
import org.apache.servicecomb.core.filter.ProviderFilter;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.slf4j.MDC;

public class ScheduleFilter
extends AbstractFilter
implements ProviderFilter {
    public static final String NAME = "schedule";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int getOrder() {
        return 0;
    }

    @Override
    public CompletableFuture<Response> onFilter(Invocation invocation, FilterNode next) {
        invocation.getInvocationStageTrace().startProviderQueue();
        Executor executor = invocation.getOperationMeta().getExecutor();
        return CompletableFuture.completedFuture(null).thenComposeAsync(response -> this.runInExecutor(invocation, next), executor);
    }

    protected CompletableFuture<Response> runInExecutor(Invocation invocation, FilterNode next) {
        invocation.getInvocationStageTrace().finishProviderQueue();
        MDC.put((String)"SERVICECOMB_TRACE_ID", (String)invocation.getTraceId());
        this.checkInQueueTimeout(invocation);
        return next.onFilter(invocation);
    }

    private void checkInQueueTimeout(Invocation invocation) {
        long nanoTimeout = invocation.getOperationMeta().getConfig().getNanoRequestWaitInPoolTimeout(invocation.getTransport().getName());
        if (invocation.getInvocationStageTrace().calcQueue() > nanoTimeout) {
            throw new InvocationException((Response.StatusType)Response.Status.REQUEST_TIMEOUT, "Request in the queue timed out.");
        }
    }
}

