/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.rest.vertx;

import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import jakarta.ws.rs.core.Response;
import org.apache.servicecomb.common.rest.RestProducerInvocationFlow;
import org.apache.servicecomb.common.rest.RestVertxProducerInvocationCreator;
import org.apache.servicecomb.core.SCBEngine;
import org.apache.servicecomb.core.Transport;
import org.apache.servicecomb.core.definition.MicroserviceMeta;
import org.apache.servicecomb.core.invocation.InvocationCreator;
import org.apache.servicecomb.foundation.common.LegacyPropertyFactory;
import org.apache.servicecomb.foundation.vertx.http.HttpServletRequestEx;
import org.apache.servicecomb.foundation.vertx.http.HttpServletResponseEx;
import org.apache.servicecomb.foundation.vertx.http.VertxServerRequestToHttpServletRequest;
import org.apache.servicecomb.foundation.vertx.http.VertxServerResponseToHttpServletResponse;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.apache.servicecomb.transport.rest.vertx.AbstractVertxHttpDispatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertxRestDispatcher
extends AbstractVertxHttpDispatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(VertxRestDispatcher.class);
    private static final String KEY_ORDER = "servicecomb.http.dispatcher.rest.order";
    private static final String KEY_ENABLED = "servicecomb.http.dispatcher.rest.enabled";
    public static final String KEY_PATTERN = "servicecomb.http.dispatcher.rest.pattern";
    private Transport transport;
    private MicroserviceMeta microserviceMeta;

    public int getOrder() {
        return LegacyPropertyFactory.getIntProperty((String)KEY_ORDER, (int)Integer.MAX_VALUE);
    }

    @Override
    public boolean enabled() {
        return LegacyPropertyFactory.getBooleanProperty((String)KEY_ENABLED, (boolean)true);
    }

    @Override
    public void init(Router router) {
        String pattern = LegacyPropertyFactory.getStringProperty((String)KEY_PATTERN);
        if (pattern == null) {
            router.route().handler((Handler)this.createBodyHandler());
            router.route().failureHandler(this::failureHandler).handler(this::onRequest);
        } else {
            router.routeWithRegex(pattern).handler((Handler)this.createBodyHandler());
            router.routeWithRegex(pattern).failureHandler(this::failureHandler).handler(this::onRequest);
        }
    }

    protected void failureHandler(RoutingContext context) {
        Throwable cause;
        LOGGER.error("http server failed.", context.failure());
        Throwable e = context.failure();
        if (e instanceof HttpPostRequestDecoder.ErrorDataDecoderException && (cause = e.getCause()) instanceof InvocationException) {
            e = cause;
        }
        this.handleFailureAndClose(context, e);
    }

    private void handleFailureAndClose(RoutingContext context, Throwable e) {
        if (null != e) {
            this.sendExceptionByRoutingContext(context, e);
            return;
        }
        this.sendFailureRespDeterminedByStatus(context);
    }

    private void sendFailureRespDeterminedByStatus(RoutingContext context) {
        Response.Status.Family statusFamily = Response.Status.Family.familyOf((int)context.statusCode());
        if (Response.Status.Family.CLIENT_ERROR.equals((Object)statusFamily) || Response.Status.Family.SERVER_ERROR.equals((Object)statusFamily) || Response.Status.Family.OTHER.equals((Object)statusFamily)) {
            context.response().putHeader("Content-Type", "*/*").setStatusCode(context.statusCode()).end();
        } else {
            context.response().putHeader("Content-Type", "*/*").setStatusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).setStatusMessage(Response.Status.INTERNAL_SERVER_ERROR.getReasonPhrase()).end(this.wrapResponseBody(Response.Status.INTERNAL_SERVER_ERROR.getReasonPhrase()));
        }
        context.response().close();
    }

    private void sendExceptionByRoutingContext(RoutingContext context, Throwable e) {
        if (e instanceof InvocationException) {
            InvocationException invocationException = (InvocationException)e;
            context.response().putHeader("Content-Type", "*/*").setStatusCode(invocationException.getStatusCode()).setStatusMessage(invocationException.getReasonPhrase()).end(this.wrapResponseBody(invocationException.getReasonPhrase()));
        } else {
            context.response().putHeader("Content-Type", "*/*").setStatusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).end(this.wrapResponseBody(Response.Status.INTERNAL_SERVER_ERROR.getReasonPhrase()));
        }
        context.response().close();
    }

    String wrapResponseBody(String message) {
        if (this.isValidJson(message)) {
            return message;
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.put("message", (Object)message);
        return jsonObject.toString();
    }

    private boolean isValidJson(String message) {
        try {
            new JsonObject(message);
        }
        catch (Exception ignored) {
            return false;
        }
        return true;
    }

    protected void onRequest(RoutingContext context) {
        if (this.transport == null) {
            this.transport = SCBEngine.getInstance().getTransportManager().findTransport("rest");
            this.microserviceMeta = SCBEngine.getInstance().getProducerMicroserviceMeta();
        }
        VertxServerRequestToHttpServletRequest requestEx = new VertxServerRequestToHttpServletRequest(context);
        VertxServerResponseToHttpServletResponse responseEx = new VertxServerResponseToHttpServletResponse(context.response());
        RestVertxProducerInvocationCreator creator = new RestVertxProducerInvocationCreator(context, this.microserviceMeta, this.transport.getEndpoint(), (HttpServletRequestEx)requestEx, (HttpServletResponseEx)responseEx);
        new RestProducerInvocationFlow((InvocationCreator)creator, (HttpServletRequestEx)requestEx, (HttpServletResponseEx)responseEx).run();
    }
}

