/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.registry.discovery;

import java.util.ArrayList;
import java.util.List;
import org.apache.servicecomb.registry.api.MicroserviceInstanceStatus;
import org.apache.servicecomb.registry.discovery.AbstractGroupDiscoveryFilter;
import org.apache.servicecomb.registry.discovery.DiscoveryContext;
import org.apache.servicecomb.registry.discovery.DiscoveryTreeNode;
import org.apache.servicecomb.registry.discovery.StatefulDiscoveryInstance;

public class InstanceStatusDiscoveryFilter
extends AbstractGroupDiscoveryFilter {
    public static final String PARAMETER = "status_level";
    public static final String GROUP_PREFIX = "status_group_";
    public static final String GROUP_SIZE = "status_group_size";
    public static final String SERVICECOMB_LOADBALANCE_FILTER_STATUS_ENABLED = "servicecomb.loadbalance.filter.status.enabled";

    public int getOrder() {
        return -10000;
    }

    @Override
    public boolean enabled() {
        if (this.enabled == null) {
            this.enabled = this.dynamicProperties.getBooleanProperty(SERVICECOMB_LOADBALANCE_FILTER_STATUS_ENABLED, value -> {
                this.enabled = value;
            }, true);
        }
        return this.enabled;
    }

    @Override
    protected String groupsSizeParameter() {
        return GROUP_SIZE;
    }

    @Override
    protected String contextParameter() {
        return PARAMETER;
    }

    @Override
    protected String groupPrefix() {
        return GROUP_PREFIX;
    }

    @Override
    public void init(DiscoveryContext context, DiscoveryTreeNode parent) {
        List instances = (List)parent.data();
        ArrayList<StatefulDiscoveryInstance> level0 = new ArrayList<StatefulDiscoveryInstance>();
        ArrayList<StatefulDiscoveryInstance> level1 = new ArrayList<StatefulDiscoveryInstance>();
        ArrayList<StatefulDiscoveryInstance> level2 = new ArrayList<StatefulDiscoveryInstance>();
        ArrayList<StatefulDiscoveryInstance> level3 = new ArrayList<StatefulDiscoveryInstance>();
        int groups = 1;
        for (StatefulDiscoveryInstance instance : instances) {
            if (StatefulDiscoveryInstance.HistoryStatus.CURRENT == instance.getHistoryStatus() && MicroserviceInstanceStatus.UP == instance.getStatus() && StatefulDiscoveryInstance.PingStatus.OK == instance.getPingStatus() && StatefulDiscoveryInstance.IsolationStatus.NORMAL == instance.getIsolationStatus()) {
                level0.add(instance);
                continue;
            }
            if (StatefulDiscoveryInstance.HistoryStatus.CURRENT == instance.getHistoryStatus() && MicroserviceInstanceStatus.UP == instance.getStatus() && StatefulDiscoveryInstance.PingStatus.UNKNOWN == instance.getPingStatus() && StatefulDiscoveryInstance.IsolationStatus.NORMAL == instance.getIsolationStatus()) {
                level1.add(instance);
                continue;
            }
            if (StatefulDiscoveryInstance.HistoryStatus.HISTORY == instance.getHistoryStatus() && MicroserviceInstanceStatus.UP == instance.getStatus() && StatefulDiscoveryInstance.PingStatus.OK == instance.getPingStatus() && StatefulDiscoveryInstance.IsolationStatus.NORMAL == instance.getIsolationStatus()) {
                level2.add(instance);
                continue;
            }
            level3.add(instance);
        }
        if (!level0.isEmpty()) {
            parent.child(GROUP_PREFIX + groups, (DiscoveryTreeNode)new DiscoveryTreeNode().subName(parent, GROUP_PREFIX + groups).data(level0));
            ++groups;
        }
        if (!level1.isEmpty()) {
            parent.child(GROUP_PREFIX + groups, (DiscoveryTreeNode)new DiscoveryTreeNode().subName(parent, GROUP_PREFIX + groups).data(level1));
            ++groups;
        }
        if (!level2.isEmpty()) {
            parent.child(GROUP_PREFIX + groups, (DiscoveryTreeNode)new DiscoveryTreeNode().subName(parent, GROUP_PREFIX + groups).data(level2));
            ++groups;
        }
        parent.child(GROUP_PREFIX + groups, (DiscoveryTreeNode)new DiscoveryTreeNode().subName(parent, GROUP_PREFIX + groups).data(level3));
        parent.attribute(GROUP_SIZE, groups);
    }
}

