/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.rest.client;

import io.vertx.core.Context;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpConnection;
import java.util.Optional;
import org.apache.servicecomb.common.rest.definition.RestOperationMeta;
import org.apache.servicecomb.swagger.invocation.context.VertxTransportContext;
import org.apache.servicecomb.transport.rest.client.BoundaryFactory;
import org.apache.servicecomb.transport.rest.client.RestClientRequestParameters;
import org.apache.servicecomb.transport.rest.client.RestClientRequestParametersImpl;

public class RestClientTransportContext
implements VertxTransportContext {
    protected final RestOperationMeta restOperationMeta;
    protected final Context vertxContext;
    protected final HttpClientRequest httpClientRequest;
    protected final RestClientRequestParameters requestParameters;
    protected final BoundaryFactory boundaryFactory;
    protected String boundary;
    protected HttpClientResponse httpClientResponse;

    public RestClientTransportContext(RestOperationMeta restOperationMeta, Context vertxContext, HttpClientRequest httpClientRequest, BoundaryFactory boundaryFactory) {
        this.restOperationMeta = restOperationMeta;
        this.vertxContext = vertxContext;
        this.httpClientRequest = httpClientRequest;
        this.boundaryFactory = boundaryFactory;
        this.requestParameters = new RestClientRequestParametersImpl(httpClientRequest);
    }

    public RestOperationMeta getRestOperationMeta() {
        return this.restOperationMeta;
    }

    public boolean isDownloadFile() {
        return this.restOperationMeta.isDownloadFile();
    }

    public boolean isServerSendEvents() {
        return this.restOperationMeta.isServerSendEvents();
    }

    public Context getVertxContext() {
        return this.vertxContext;
    }

    public HttpClientRequest getHttpClientRequest() {
        return this.httpClientRequest;
    }

    public RestClientRequestParameters getRequestParameters() {
        return this.requestParameters;
    }

    public String getOrCreateBoundary() {
        if (this.boundary == null) {
            this.boundary = this.boundaryFactory.create();
        }
        return this.boundary;
    }

    public HttpClientResponse getHttpClientResponse() {
        return this.httpClientResponse;
    }

    public RestClientTransportContext setHttpClientResponse(HttpClientResponse httpClientResponse) {
        this.httpClientResponse = httpClientResponse;
        return this;
    }

    public String getLocalAddress() {
        return Optional.ofNullable(this.httpClientRequest.connection()).map(HttpConnection::localAddress).map(Object::toString).orElse("not connected");
    }
}

