/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.registry.lightweight.store;

import com.google.common.base.Ticker;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.registry.lightweight.model.Microservice;
import org.apache.servicecomb.registry.lightweight.model.MicroserviceInstance;
import org.apache.servicecomb.registry.lightweight.model.MicroserviceInstances;
import org.apache.servicecomb.registry.lightweight.store.AppStore;
import org.apache.servicecomb.registry.lightweight.store.InstanceStore;
import org.apache.servicecomb.registry.lightweight.store.MicroserviceStore;

public class Store {
    private Ticker ticker = Ticker.systemTicker();
    private final Map<String, AppStore> appsById = new ConcurrentHashMapEx();
    private final Map<String, MicroserviceStore> microservicesByName = new ConcurrentHashMapEx();
    private final Map<String, MicroserviceStore> microservicesById = new ConcurrentHashMapEx();
    private final Map<String, InstanceStore> instancesById = new ConcurrentHashMapEx();

    public Store setTicker(Ticker ticker) {
        this.ticker = ticker;
        return this;
    }

    public AppStore getOrCreateAppStore(String appId) {
        return this.appsById.computeIfAbsent(appId, key -> new AppStore());
    }

    public MicroserviceStore findMicroserviceStore(String serviceId) {
        return this.microservicesById.get(serviceId);
    }

    public InstanceStore findInstanceStore(String instanceId) {
        return this.instancesById.get(instanceId);
    }

    public MicroserviceStore addMicroservice(Microservice microservice) {
        MicroserviceStore microserviceStore = new MicroserviceStore(this.ticker, microservice);
        this.getOrCreateAppStore(microservice.getAppId()).addMicroservice(microserviceStore);
        this.microservicesById.put(microservice.getServiceId(), microserviceStore);
        this.microservicesByName.put(microservice.getServiceName(), microserviceStore);
        return microserviceStore;
    }

    public InstanceStore addInstance(MicroserviceStore microserviceStore, MicroserviceInstance instance) {
        InstanceStore instanceStore = microserviceStore.addInstance(instance);
        this.instancesById.put(instance.getInstanceId(), instanceStore);
        return instanceStore;
    }

    public InstanceStore deleteInstance(String serviceId, String instanceId) {
        MicroserviceStore microserviceStore = this.findMicroserviceStore(serviceId);
        if (microserviceStore == null) {
            return null;
        }
        InstanceStore instanceStore = microserviceStore.deleteInstance(instanceId);
        if (instanceStore != null) {
            this.instancesById.remove(instanceId);
        }
        return instanceStore;
    }

    public Optional<Microservice> getMicroservice(String microserviceId) {
        return Optional.ofNullable(this.microservicesById.get(microserviceId)).map(MicroserviceStore::getMicroservice);
    }

    public Optional<MicroserviceInstance> getMicroserviceInstance(String instanceId) {
        return Optional.ofNullable(this.instancesById.get(instanceId)).map(InstanceStore::getInstance);
    }

    public MicroserviceInstances findServiceInstances(String appId, String serviceName, String revision) {
        return Optional.ofNullable(this.appsById.get(appId)).map(appStore -> appStore.findServiceInstances(serviceName, revision)).orElse(new MicroserviceInstances().setMicroserviceNotExist(true));
    }

    public List<Microservice> getAllMicroservices() {
        return this.microservicesByName.values().stream().map(MicroserviceStore::getMicroservice).collect(Collectors.toList());
    }

    public int getMicroserviceCount() {
        return this.microservicesByName.size();
    }

    public int getInstanceCount() {
        return this.instancesById.size();
    }

    public Stream<MicroserviceInstance> findDeadInstances(Duration timeout) {
        long nanoNow = this.ticker.read();
        long nanoTimeout = timeout.toNanos();
        return this.instancesById.values().stream().filter(instanceStore -> instanceStore.isHeartBeatTimeout(nanoNow, nanoTimeout)).map(InstanceStore::getInstance);
    }
}

