/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.metrics.core.meter.os;

import com.google.common.annotations.VisibleForTesting;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.servicecomb.foundation.metrics.meter.PeriodMeter;
import org.apache.servicecomb.metrics.core.meter.os.net.InterfaceUsage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetMeter
implements PeriodMeter {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetMeter.class);
    public static final String STATISTIC = "statistic";
    public static final String INTERFACE = "interface";
    public static final Tag TAG_RECEIVE = Tag.of((String)"statistic", (String)"receive");
    public static final Tag TAG_PACKETS_RECEIVE = Tag.of((String)"statistic", (String)"receivePackets");
    public static final Tag TAG_SEND = Tag.of((String)"statistic", (String)"send");
    public static final Tag TAG_PACKETS_SEND = Tag.of((String)"statistic", (String)"sendPackets");
    private final Map<String, InterfaceUsage> interfaceUsageMap = new ConcurrentHashMap<String, InterfaceUsage>();
    private boolean isOsLinux = SystemUtils.IS_OS_LINUX;
    protected final MeterRegistry meterRegistry;
    protected final String name;
    protected final Tags tags;

    public NetMeter(MeterRegistry meterRegistry, String name, Tags tags) {
        this.meterRegistry = meterRegistry;
        this.name = name;
        this.tags = tags;
        this.poll(0L, 0L);
    }

    @VisibleForTesting
    public void setOsLinux(boolean osLinux) {
        this.isOsLinux = osLinux;
    }

    public void poll(long msNow, long secondInterval) {
        if (this.isOsLinux) {
            this.refreshNet(secondInterval);
        }
    }

    protected void refreshNet(long secondInterval) {
        try {
            File file = new File("/proc/net/dev");
            List netInfo = FileUtils.readLines((File)file, (Charset)StandardCharsets.UTF_8);
            for (int i = 2; i < netInfo.size(); ++i) {
                String interfaceData = (String)netInfo.get(i);
                String[] strings = interfaceData.split(":");
                if (strings.length != 2) {
                    LOGGER.warn(" there is something wrong with {} ", (Object)interfaceData);
                    continue;
                }
                String interfaceName = strings[0].trim();
                InterfaceUsage interfaceUsage = this.interfaceUsageMap.computeIfAbsent(interfaceName, key -> new InterfaceUsage(this.meterRegistry, this.name, this.tags, (String)key));
                interfaceUsage.update(strings[1], secondInterval);
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to read net info/", (Throwable)e);
        }
    }

    public Map<String, InterfaceUsage> getInterfaceUsageMap() {
        return this.interfaceUsageMap;
    }
}

