/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.accessLog.client;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import org.apache.servicecomb.common.accessLog.AccessLogConfig;
import org.apache.servicecomb.common.accessLog.AccessLogInitializer;
import org.apache.servicecomb.common.accessLog.core.AccessLogGenerator;
import org.apache.servicecomb.core.event.InvocationFinishEvent;
import org.apache.servicecomb.swagger.invocation.InvocationType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientDefaultInitializer
implements AccessLogInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"scb-access");
    private AccessLogGenerator accessLogGenerator;

    @Override
    public void init(EventBus eventBus, AccessLogConfig accessLogConfig) {
        if (!accessLogConfig.isClientLogEnabled()) {
            return;
        }
        this.accessLogGenerator = new AccessLogGenerator(accessLogConfig.getClientLogPattern());
        eventBus.register((Object)this);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onRequestOut(InvocationFinishEvent finishEvent) {
        if (InvocationType.CONSUMER.equals((Object)finishEvent.getInvocation().getInvocationType())) {
            LOGGER.info(this.accessLogGenerator.generateClientLog(finishEvent));
        }
    }
}

