/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.loadbalance.filter;

import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.config.BootStrapProperties;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.foundation.common.cache.VersionedCache;
import org.apache.servicecomb.loadbalance.filter.InstancePropertyDiscoveryFilter;
import org.apache.servicecomb.registry.discovery.AbstractDiscoveryFilter;
import org.apache.servicecomb.registry.discovery.DiscoveryContext;
import org.apache.servicecomb.registry.discovery.DiscoveryTreeNode;
import org.apache.servicecomb.registry.discovery.StatefulDiscoveryInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;

public class PriorityInstancePropertyDiscoveryFilter
extends AbstractDiscoveryFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(PriorityInstancePropertyDiscoveryFilter.class);
    private static final String ALL_INSTANCE = "allInstance";
    public static final String SERVICECOMB_LOADBALANCE_FILTER_PRIORITY_INSTANCE_PROPERTY_KEY = "servicecomb.loadbalance.filter.priorityInstanceProperty.key";
    private String propertyKey;
    private Environment environment;

    @Autowired
    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    protected void init(DiscoveryContext context, DiscoveryTreeNode parent) {
        this.propertyKey = this.dynamicProperties.getStringProperty(SERVICECOMB_LOADBALANCE_FILTER_PRIORITY_INSTANCE_PROPERTY_KEY, value -> {
            this.propertyKey = value;
        }, "environment");
        List instances = (List)parent.data();
        HashMap<String, List> groupByProperty = new HashMap<String, List>();
        for (StatefulDiscoveryInstance microserviceInstance : instances) {
            String propertyValue = new PriorityInstanceProperty(this.propertyKey, microserviceInstance).getPropertyValue();
            groupByProperty.computeIfAbsent(propertyValue, key -> new ArrayList()).add(microserviceInstance);
        }
        HashMap<String, DiscoveryTreeNode> children = new HashMap<String, DiscoveryTreeNode>();
        for (Map.Entry entry : groupByProperty.entrySet()) {
            children.put((String)entry.getKey(), (DiscoveryTreeNode)new DiscoveryTreeNode().subName((VersionedCache)parent, (String)entry.getKey()).data(entry.getValue()));
        }
        children.put(ALL_INSTANCE, (DiscoveryTreeNode)new DiscoveryTreeNode().subName((VersionedCache)parent, ALL_INSTANCE).data((Object)instances));
        parent.children(children);
    }

    protected String findChildName(DiscoveryContext context, DiscoveryTreeNode parent) {
        Invocation invocation = (Invocation)context.getInputParameters();
        String initPropertyValue = invocation.getContext().computeIfAbsent("x-" + this.propertyKey, key -> new PriorityInstanceProperty(this.propertyKey, (String)BootStrapProperties.readServiceProperties((Environment)this.environment).get(this.propertyKey)).getPropertyValue());
        PriorityInstanceProperty currentProperty = (PriorityInstanceProperty)context.getContextParameter(this.propertyKey);
        if (Objects.isNull(currentProperty)) {
            currentProperty = new PriorityInstanceProperty(this.propertyKey, initPropertyValue);
            while (!parent.children().containsKey(currentProperty.getPropertyValue()) && currentProperty.hasChildren()) {
                currentProperty = currentProperty.child();
            }
        } else if (currentProperty.hasChildren()) {
            currentProperty = currentProperty.child();
        }
        LOGGER.debug("Discovery instance filter by {}", (Object)currentProperty);
        context.putContextParameter(this.propertyKey, (Object)currentProperty);
        if (currentProperty.isEmpty()) {
            return currentProperty.getPropertyValue();
        }
        context.pushRerunFilter();
        return currentProperty.getPropertyValue();
    }

    public boolean enabled() {
        if (this.enabled == null) {
            this.enabled = this.dynamicProperties.getBooleanProperty("servicecomb.loadbalance.filter.priorityInstanceProperty.enabled", value -> {
                this.enabled = value;
            }, false);
        }
        return this.enabled;
    }

    public int getOrder() {
        return new InstancePropertyDiscoveryFilter().getOrder() + 1;
    }

    static class PriorityInstanceProperty {
        private static final int MAX_LENGTH = 10000;
        private static final String SEPARATOR = ".";
        private final String propertyKey;
        private final String propertyVal;

        public PriorityInstanceProperty(@NotNull String key, String value) {
            this.propertyKey = key;
            if (Objects.isNull(value)) {
                value = "";
            }
            if (value.length() > 10000) {
                throw new IllegalArgumentException("property value exceed max length");
            }
            this.propertyVal = value;
        }

        public PriorityInstanceProperty(@NotNull String key, @NotNull StatefulDiscoveryInstance microserviceInstance) {
            this(key, Optional.ofNullable((String)microserviceInstance.getProperties().get(key)).orElse(""));
        }

        public boolean isEmpty() {
            return StringUtils.isEmpty((CharSequence)this.propertyVal);
        }

        public boolean hasChildren() {
            return StringUtils.isNotEmpty((CharSequence)this.propertyVal);
        }

        public PriorityInstanceProperty child() {
            if (this.propertyVal.contains(SEPARATOR)) {
                return new PriorityInstanceProperty(this.propertyKey, StringUtils.substringBeforeLast((String)this.propertyVal, (String)SEPARATOR));
            }
            return new PriorityInstanceProperty(this.propertyKey, "");
        }

        public String getPropertyValue() {
            return this.propertyVal;
        }

        public String toString() {
            return "PriorityInstanceProperty{key=" + this.propertyKey + ", value=" + this.propertyVal + "}";
        }
    }
}

