/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config.cc;

import java.util.Collections;
import java.util.List;
import org.apache.servicecomb.config.ConfigUtil;
import org.springframework.core.env.Environment;

public final class ConfigCenterConfig {
    public static final String SSL_TAG = "cc.consumer";
    private static final String ADDRESS = "servicecomb.config.client.serverUri";
    private static final String DOMAIN_NAME = "servicecomb.config.client.domainName";
    private static final String REFRESH_INTERVAL = "servicecomb.config.client.refresh_interval";
    private static final String FIRST_PULL_REQUIRED = "servicecomb.config.client.firstPullRequired";
    public static final String FILE_SOURCE = "servicecomb.config.client.fileSource";
    private static final int DEFAULT_REFRESH_INTERVAL = 15000;
    private final Environment environment;

    public ConfigCenterConfig(Environment environment) {
        this.environment = environment;
    }

    public String getDomainName() {
        return this.environment.getProperty(DOMAIN_NAME, "default");
    }

    public boolean firstPullRequired() {
        return (Boolean)this.environment.getProperty(FIRST_PULL_REQUIRED, Boolean.TYPE, (Object)false);
    }

    public List<String> getFileSources() {
        return (List)this.environment.getProperty(FILE_SOURCE, List.class, Collections.emptyList());
    }

    public long getRefreshInterval() {
        return (Long)this.environment.getProperty(REFRESH_INTERVAL, Long.TYPE, (Object)15000L);
    }

    public Boolean isProxyEnable() {
        return (Boolean)this.environment.getProperty("servicecomb.proxy.enable", Boolean.TYPE, (Object)false);
    }

    public String getProxyHost() {
        return this.environment.getProperty("servicecomb.proxy.host", "127.0.0.1");
    }

    public int getProxyPort() {
        return (Integer)this.environment.getProperty("servicecomb.proxy.port", Integer.TYPE, (Object)8080);
    }

    public String getProxyUsername() {
        return this.environment.getProperty("servicecomb.proxy.username");
    }

    public String getProxyPasswd() {
        return this.environment.getProperty("servicecomb.proxy.passwd");
    }

    public List<String> getServerUri() {
        return ConfigUtil.parseArrayValue((String)this.environment.getProperty(ADDRESS, ""));
    }
}

