/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.generator.springmvc.processor.annotation;

import io.swagger.models.Operation;
import org.apache.servicecomb.swagger.SwaggerUtils;
import org.apache.servicecomb.swagger.generator.MethodAnnotationProcessor;
import org.apache.servicecomb.swagger.generator.OperationGenerator;
import org.springframework.web.bind.annotation.RequestMethod;

abstract class AbstractHttpMethodMappingAnnotationProcessor<ANNOTATION>
implements MethodAnnotationProcessor<ANNOTATION> {
    AbstractHttpMethodMappingAnnotationProcessor() {
    }

    protected void doProcess(OperationGenerator operationGenerator, String[] paths, String[] pathValues, RequestMethod requestMethod, String[] consumes, String[] produces) {
        Operation operation = operationGenerator.getOperation();
        this.processPath(operationGenerator, paths);
        this.processPath(operationGenerator, pathValues);
        if (requestMethod != null) {
            operationGenerator.setHttpMethod(requestMethod.name());
        }
        SwaggerUtils.setConsumes((Operation)operation, (String[])consumes);
        SwaggerUtils.setProduces((Operation)operation, (String[])produces);
    }

    protected void processPath(OperationGenerator operationGenerator, String[] paths) {
        if (null == paths || paths.length == 0) {
            return;
        }
        if (paths.length > 1) {
            throw new IllegalStateException("not allowed multi path.");
        }
        operationGenerator.setPath(paths[0]);
    }
}

