/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.filter;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.servicecomb.core.filter.Filter;
import org.apache.servicecomb.core.filter.FilterNode;
import org.apache.servicecomb.core.filter.InternalFilter;
import org.apache.servicecomb.core.filter.InvocationFilterChains;
import org.apache.servicecomb.core.filter.config.FilterChainsConfig;
import org.apache.servicecomb.foundation.common.utils.StringBuilderUtils;
import org.apache.servicecomb.swagger.invocation.InvocationType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FilterChainsManager {
    private final FilterChainsConfig chainsConfig = new FilterChainsConfig();
    private final InvocationFilterChains consumerChains = new InvocationFilterChains();
    private final InvocationFilterChains producerChains = new InvocationFilterChains();

    @Autowired
    public FilterChainsManager addFilters(List<Filter> filters) {
        for (Filter filter : filters) {
            if (filter.getInvocationTypes().contains(InvocationType.CONSUMER)) {
                this.consumerChains.addFilter(filter);
            }
            if (!filter.getInvocationTypes().contains(InvocationType.PRODUCER)) continue;
            this.producerChains.addFilter(filter);
        }
        return this;
    }

    public FilterChainsManager init() {
        this.chainsConfig.load();
        this.consumerChains.resolve(this.chainsConfig.getResolver(), this.chainsConfig.getConsumer());
        this.producerChains.resolve(this.chainsConfig.getResolver(), this.chainsConfig.getProducer());
        return this;
    }

    public boolean isEnabled() {
        return this.chainsConfig.isEnabled();
    }

    public FilterNode findConsumerChain(String microserviceName) {
        return this.consumerChains.findChain(microserviceName);
    }

    public FilterNode findProducerChain(String microserviceName) {
        return this.producerChains.findChain(microserviceName);
    }

    public String collectResolvedChains() {
        StringBuilder sb = new StringBuilder();
        StringBuilderUtils.appendLine((StringBuilder)sb, (String)"consumer: ", (Object[])new Object[0]);
        StringBuilderUtils.appendLine((StringBuilder)sb, (String)"  filters: %s", (Object[])new Object[]{this.collectFilterNames(this.consumerChains)});
        this.collectChainsByInvocationType(sb, this.consumerChains);
        StringBuilderUtils.appendLine((StringBuilder)sb, (String)"producer: ", (Object[])new Object[0]);
        StringBuilderUtils.appendLine((StringBuilder)sb, (String)"  filters: %s", (Object[])new Object[]{this.collectFilterNames(this.producerChains)});
        this.collectChainsByInvocationType(sb, this.producerChains);
        return StringBuilderUtils.deleteLast((StringBuilder)sb, (int)1).toString();
    }

    public List<String> collectFilterNames(InvocationFilterChains chains) {
        return chains.getFilters().stream().filter(filter -> !(filter instanceof InternalFilter)).map(Filter::getName).collect(Collectors.toList());
    }

    private void collectChainsByInvocationType(StringBuilder sb, InvocationFilterChains chains) {
        StringBuilderUtils.appendLine((StringBuilder)sb, (String)"  chains:", (Object[])new Object[0]);
        StringBuilderUtils.appendLine((StringBuilder)sb, (String)"    framework: %s", (Object[])new Object[]{chains.getResolvedFrameworkConfig()});
        StringBuilderUtils.appendLine((StringBuilder)sb, (String)"    default  : %s", (Object[])new Object[]{chains.getResolvedDefaultConfig()});
        for (Map.Entry<String, List<Object>> entry : chains.getResolvedMicroserviceConfig().entrySet()) {
            StringBuilderUtils.appendLine((StringBuilder)sb, (String)"    %s: %s", (Object[])new Object[]{entry.getKey(), entry.getValue()});
        }
    }
}

