/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.protobuf.internal.schema.serializer;

import com.fasterxml.jackson.databind.JavaType;
import io.protostuff.InputEx;
import io.protostuff.OutputEx;
import io.protostuff.SchemaEx;
import io.protostuff.compiler.model.Field;
import io.protostuff.compiler.model.FieldContainer;
import io.protostuff.compiler.model.Message;
import io.protostuff.runtime.FieldMapEx;
import io.protostuff.runtime.FieldSchema;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.foundation.protobuf.ProtoMapper;
import org.apache.servicecomb.foundation.protobuf.internal.ProtoUtils;
import org.apache.servicecomb.foundation.protobuf.internal.bean.BeanDescriptor;
import org.apache.servicecomb.foundation.protobuf.internal.bean.PropertyDescriptor;
import org.apache.servicecomb.foundation.protobuf.internal.schema.serializer.SerializerSchemaManager;

public class MessageWriteSchema<T>
implements SchemaEx<T> {
    protected final ProtoMapper protoMapper;
    protected final Message message;
    private final JavaType javaType;
    private final Class<T> mainPojoCls;
    private FieldMapEx<T> mainPojoFieldMaps;
    private FieldMapEx<Map<Object, Object>> mapFieldMaps;
    private final Map<Class<?>, FieldMapEx<?>> pojoFieldMaps = new ConcurrentHashMapEx();

    public MessageWriteSchema(ProtoMapper protoMapper, Message message, JavaType javaType) {
        this.protoMapper = protoMapper;
        this.message = message;
        this.javaType = javaType;
        this.mainPojoCls = javaType.getRawClass();
    }

    public Message getMessage() {
        return this.message;
    }

    @Override
    public T newMessage() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String messageName() {
        return this.message.getName();
    }

    public JavaType getJavaType() {
        return this.javaType;
    }

    public Class<T> getMainPojoCls() {
        return this.mainPojoCls;
    }

    public FieldMapEx<T> getMainPojoFieldMaps() {
        return this.mainPojoFieldMaps;
    }

    @Override
    public void init() {
        if (ProtoUtils.isWrapProperty((FieldContainer)this.message)) {
            this.mainPojoFieldMaps = this.createPropertyWrapperFields(this.javaType);
            return;
        }
        this.mainPojoFieldMaps = this.createPojoFields((Type)this.javaType);
    }

    private FieldMapEx<T> createPropertyWrapperFields(JavaType javaType) {
        Field protoField = this.message.getField(1);
        PropertyDescriptor propertyDescriptor = new PropertyDescriptor();
        propertyDescriptor.setName(protoField.getName());
        propertyDescriptor.setJavaType(javaType);
        FieldSchema fieldSchema = this.protoMapper.getSerializerSchemaManager().createSchemaField(protoField, propertyDescriptor);
        return FieldMapEx.createFieldMap(Arrays.asList(fieldSchema));
    }

    private FieldMapEx<T> createPojoFields(Type type) {
        SerializerSchemaManager serializerSchemaManager = this.protoMapper.getSerializerSchemaManager();
        BeanDescriptor beanDescriptor = this.protoMapper.getBeanDescriptorManager().getOrCreateBeanDescriptor(type);
        ArrayList fieldSchemas = new ArrayList();
        for (Field protoField : this.message.getFields()) {
            Object getter;
            PropertyDescriptor propertyDescriptor = beanDescriptor.getPropertyDescriptors().get(protoField.getName());
            if (propertyDescriptor == null || (getter = propertyDescriptor.getGetter()) == null) continue;
            FieldSchema fieldSchema = serializerSchemaManager.createSchemaField(protoField, propertyDescriptor);
            fieldSchemas.add(fieldSchema);
        }
        return FieldMapEx.createFieldMap(fieldSchemas);
    }

    @Override
    public void writeTo(OutputEx output, Object value) throws IOException {
        if (value instanceof Map) {
            this.writeFromMap(output, (Map)value);
            return;
        }
        if (this.mainPojoCls == value.getClass()) {
            this.writeFromMainPojo(output, value);
            return;
        }
        this.writeDynamicPojo(output, value);
    }

    private void writeFromMainPojo(OutputEx output, T value) throws IOException {
        for (FieldSchema<T> fieldSchema : this.mainPojoFieldMaps.getFields()) {
            fieldSchema.getAndWriteTo(output, value);
        }
    }

    private <T> void writeDynamicPojo(OutputEx output, Object dynamicValue) throws IOException {
        FieldMapEx fieldMapEx = this.pojoFieldMaps.computeIfAbsent(dynamicValue.getClass(), this::createPojoFields);
        Object value = dynamicValue;
        for (FieldSchema<Object> fieldSchema : fieldMapEx.getFields()) {
            fieldSchema.getAndWriteTo(output, value);
        }
    }

    protected final void writeFromMap(OutputEx output, Map<String, Object> map) throws IOException {
        if (this.mapFieldMaps == null) {
            this.mapFieldMaps = this.protoMapper.getSerializerSchemaManager().createMapFields(this.message);
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            FieldSchema<Map<Object, Object>> fieldSchema;
            if (entry.getValue() == null || (fieldSchema = this.mapFieldMaps.getFieldByName(entry.getKey())) == null) continue;
            fieldSchema.writeTo(output, entry.getValue());
        }
    }

    @Override
    public void mergeFrom(InputEx input, T message) throws IOException {
        throw new UnsupportedOperationException();
    }
}

