/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.message.protocol;

import org.apache.rocketmq.shaded.com.google.common.base.MoreObjects;
import org.apache.rocketmq.shaded.com.google.common.base.Objects;
import org.apache.rocketmq.shaded.commons.lang3.StringUtils;

public class Resource {
    private final String namespace;
    private final String name;

    public Resource(String namespace, String name) {
        this.namespace = namespace;
        this.name = name;
    }

    public Resource(String name) {
        this.namespace = "";
        this.name = name;
    }

    public Resource(apache.rocketmq.v2.Resource resource) {
        this.namespace = resource.getResourceNamespace();
        this.name = resource.getName();
    }

    public apache.rocketmq.v2.Resource toProtobuf() {
        return apache.rocketmq.v2.Resource.newBuilder().setResourceNamespace(this.namespace).setName(this.name).build();
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Resource resource = (Resource)o;
        return Objects.equal(this.namespace, resource.namespace) && Objects.equal(this.name, resource.name);
    }

    public int hashCode() {
        return Objects.hashCode(this.namespace, this.name);
    }

    public String toString() {
        if (!StringUtils.isEmpty(this.namespace)) {
            return MoreObjects.toStringHelper(this).add("name", this.name).add("namespace", this.namespace).toString();
        }
        return this.name;
    }
}

