/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.process;

import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.pdfbox.preflight.process.AbstractProcess;

public class FileSpecificationValidationProcess
extends AbstractProcess {
    @Override
    public void validate(PreflightContext ctx) throws ValidationException {
        COSDocument cDoc = ctx.getDocument().getDocument();
        cDoc.getObjectsByType(COSName.FILESPEC, COSName.F).forEach(o -> this.validateFileSpecification(ctx, (COSDictionary)o.getObject()));
    }

    public void validateFileSpecification(PreflightContext ctx, COSDictionary fileSpec) {
        if (fileSpec.getItem(COSName.EF) != null) {
            this.addValidationError(ctx, new ValidationResult.ValidationError("1.2.9", "EmbeddedFile entry is present in a FileSpecification dictionary"));
        }
    }
}

