/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.job;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ElementKind;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.Path;
import jakarta.validation.TraversableResolver;
import jakarta.validation.UnexpectedTypeException;
import jakarta.validation.ValidationException;
import jakarta.validation.constraintvalidation.ValidationTarget;
import jakarta.validation.groups.Default;
import jakarta.validation.metadata.CascadableDescriptor;
import jakarta.validation.metadata.ContainerDescriptor;
import jakarta.validation.metadata.PropertyDescriptor;
import jakarta.validation.metadata.ValidateUnwrappedValue;
import jakarta.validation.valueextraction.ValueExtractor;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.bval.jsr.ApacheFactoryContext;
import org.apache.bval.jsr.ConstraintViolationImpl;
import org.apache.bval.jsr.GraphContext;
import org.apache.bval.jsr.descriptor.BeanD;
import org.apache.bval.jsr.descriptor.ComposedD;
import org.apache.bval.jsr.descriptor.ConstraintD;
import org.apache.bval.jsr.descriptor.ContainerElementTypeD;
import org.apache.bval.jsr.descriptor.DescriptorManager;
import org.apache.bval.jsr.descriptor.ElementD;
import org.apache.bval.jsr.descriptor.PropertyD;
import org.apache.bval.jsr.groups.Group;
import org.apache.bval.jsr.groups.GroupStrategy;
import org.apache.bval.jsr.groups.Groups;
import org.apache.bval.jsr.job.ComputeConstraintValidatorClass;
import org.apache.bval.jsr.job.ConstraintValidatorContextImpl;
import org.apache.bval.jsr.metadata.ContainerElementKey;
import org.apache.bval.jsr.util.NodeImpl;
import org.apache.bval.jsr.util.PathImpl;
import org.apache.bval.jsr.util.Proxies;
import org.apache.bval.jsr.valueextraction.ExtractValues;
import org.apache.bval.jsr.valueextraction.ValueExtractors;
import org.apache.bval.util.Exceptions;
import org.apache.bval.util.Lazy;
import org.apache.bval.util.ObjectUtils;
import org.apache.bval.util.Validate;
import org.apache.bval.util.reflection.TypeUtils;

public abstract class ValidationJob<T> {
    private static final ConstraintValidator NOOP_VALIDATOR = (o, ctx) -> true;
    protected static final TypeVariable<?> MAP_VALUE = Map.class.getTypeParameters()[1];
    protected static final TypeVariable<?> ITERABLE_ELEMENT = Iterable.class.getTypeParameters()[0];
    protected final ApacheFactoryContext validatorContext;
    protected final Groups groups;
    private final Lazy<Set<ConstraintViolation<T>>> results = new Lazy<Set>(LinkedHashSet::new);
    private ConcurrentMap<ConstraintD<?>, ConcurrentMap<Path, Set<Object>>> completedValidations;

    private static Stream<ConstraintD<?>> constraintsFor(ElementD<?, ?> descriptor, GroupStrategy groups) {
        return descriptor.getConstraintDescriptors().stream().map(ConstraintD.class::cast).filter(c -> {
            Set<Class<?>> constraintGroups = c.getGroups();
            return groups.getGroups().stream().map(Group::getGroup).anyMatch(g -> constraintGroups.contains(g) || constraintGroups.contains(Default.class) && c.getDeclaringClass().equals(g));
        });
    }

    ValidationJob(ApacheFactoryContext validatorContext, Class<?>[] groups) {
        this.validatorContext = Validate.notNull(validatorContext, "validatorContext", new Object[0]);
        this.groups = validatorContext.getGroupsComputer().computeGroups(groups);
    }

    public final Set<ConstraintViolation<T>> getResults() {
        if (this.results.optional().isPresent()) {
            return this.results.get();
        }
        if (this.hasWork()) {
            Frame<?> baseFrame = this.computeBaseFrame();
            Validate.validState(baseFrame != null, "%s computed null baseFrame", this.getClass().getName());
            Consumer sink = this.results.consumer(Set::add);
            this.completedValidations = new ConcurrentHashMap();
            try {
                baseFrame.process(this.groups.asStrategy(), sink);
            }
            finally {
                this.completedValidations = null;
            }
            if (this.results.optional().isPresent()) {
                return Collections.unmodifiableSet(this.results.get());
            }
        }
        return (Set)((Object)this.results.reset((Set<ConstraintViolation<Supplier<Set>>>)((Object)((Supplier<Set>)Collections::emptySet))).get());
    }

    private <O> BeanD<O> getBeanDescriptor(Object bean) {
        Class<?> beanClass = Validate.notNull(bean, "bean", new Object[0]).getClass();
        Map<Class<?>, Class<?>> classCache = this.validatorContext.getFactory().getUnwrappedClassCache();
        Class<?> unwrappedClass = classCache.get(beanClass);
        if (unwrappedClass == null) {
            unwrappedClass = Proxies.classFor(beanClass);
            classCache.putIfAbsent(beanClass, unwrappedClass);
        }
        return (BeanD)this.validatorContext.getDescriptorManager().getBeanDescriptor(unwrappedClass);
    }

    final ConstraintViolationImpl<T> createViolation(String messageTemplate, ConstraintValidatorContextImpl<T> context, PathImpl propertyPath) {
        NodeImpl leafNode;
        if (!propertyPath.isRootPath() && (leafNode = propertyPath.getLeafNode()).getName() == null && leafNode.getKind() != ElementKind.BEAN && !leafNode.isInIterable()) {
            propertyPath.removeLeafNode();
        }
        return this.createViolation(messageTemplate, this.interpolate(messageTemplate, context), context, propertyPath);
    }

    abstract ConstraintViolationImpl<T> createViolation(String var1, String var2, ConstraintValidatorContextImpl<T> var3, PathImpl var4);

    protected abstract Frame<?> computeBaseFrame();

    protected abstract Class<T> getRootBeanClass();

    protected boolean hasWork() {
        return true;
    }

    protected <U> Predicate<U> noViolations(Consumer<? super U> consumer) {
        return u -> {
            int originalCount = this.violationCount();
            consumer.accept((Object)u);
            return this.violationCount() == originalCount;
        };
    }

    private int violationCount() {
        Optional<Set<ConstraintViolation<T>>> maybeResults = this.results.optional();
        return maybeResults.isPresent() ? maybeResults.get().size() : 0;
    }

    private String interpolate(String messageTemplate, MessageInterpolator.Context context) {
        try {
            return this.validatorContext.getMessageInterpolator().interpolate(messageTemplate, context);
        }
        catch (ValidationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ValidationException(e);
        }
    }

    private class UnwrappedElementConstraintValidationPseudoFrame<D extends ElementD<?, ?>>
    extends Frame<D> {
        final Lazy<IllegalStateException> exc;

        UnwrappedElementConstraintValidationPseudoFrame(Frame<D> parent, GraphContext context) {
            super(ValidationJob.this, parent, parent.descriptor, context);
            this.exc = new Lazy<IllegalStateException>(() -> Exceptions.create(IllegalStateException::new, "%s is not meant to participate in validation lifecycle", this.getClass()));
        }

        @Override
        void validateDescriptorConstraints(GroupStrategy groups, Consumer<ConstraintViolation<T>> sink) {
            throw this.exc.get();
        }

        @Override
        void recurse(GroupStrategy groups, Consumer<ConstraintViolation<T>> sink) {
            throw this.exc.get();
        }

        @Override
        Object getBean() {
            return this.parent.getBean();
        }
    }

    private class ContainerElementCascadeFrame
    extends SproutFrame<ContainerElementTypeD> {
        ContainerElementCascadeFrame(Frame<?> parent, ContainerElementTypeD descriptor, GraphContext context) {
            super(ValidationJob.this, parent, (ElementD)descriptor, context);
        }

        @Override
        void validateDescriptorConstraints(GroupStrategy groups, Consumer<ConstraintViolation<T>> sink) {
        }

        @Override
        protected GraphContext getMultiplexContext() {
            NodeImpl newLeaf;
            PathImpl path = this.context.getPath();
            GraphContext ancestor = this.context.getParent();
            Validate.validState(ancestor != null, "Expected parent context", new Object[0]);
            NodeImpl leafNode = path.getLeafNode();
            if (leafNode.getKind() == ElementKind.CONTAINER_ELEMENT) {
                path.removeLeafNode();
                while (!path.equals(ancestor.getPath())) {
                    Validate.validState((ancestor = ancestor.getParent()) != null, "Expected parent context", new Object[0]);
                }
                newLeaf = new NodeImpl.PropertyNodeImpl(leafNode);
                newLeaf.setName(null);
            } else {
                ContainerElementKey key = ((ContainerElementTypeD)this.descriptor).getKey();
                newLeaf = new NodeImpl.PropertyNodeImpl((String)null).inContainer(key.getContainerClass(), key.getTypeArgumentIndex());
            }
            path.addNode(newLeaf);
            return ancestor.child(path, this.context.getValue());
        }
    }

    private class ContainerElementConstraintsFrame
    extends SproutFrame<ContainerElementTypeD> {
        ContainerElementConstraintsFrame(Frame<?> parent, ContainerElementTypeD descriptor, GraphContext context) {
            super(ValidationJob.this, parent, (ElementD)descriptor, context);
        }

        @Override
        void recurse(GroupStrategy groups, Consumer<ConstraintViolation<T>> sink) {
        }
    }

    public static class SproutFrame<D extends ElementD<?, ?> & ContainerDescriptor>
    extends Frame<D> {
        final /* synthetic */ ValidationJob this$0;

        public SproutFrame(D descriptor, GraphContext context) {
            this(this$0, null, (ElementD)descriptor, context);
        }

        public SproutFrame(Frame<?> parent, D descriptor, GraphContext context) {
            this.this$0 = this$0;
            super((ValidationJob)this$0, parent, descriptor, context);
        }

        @Override
        void validateDescriptorConstraints(GroupStrategy groups, Consumer<ConstraintViolation<T>> sink) {
            super.validateDescriptorConstraints(groups, sink);
            if (this.context.getValue() != null) {
                ((ContainerDescriptor)((Object)this.descriptor)).getConstrainedContainerElementTypes().stream().flatMap(d -> ComposedD.unwrap(d, ContainerElementTypeD.class)).forEach(d -> {
                    if (ValidationJob.constraintsFor(d, groups).findFirst().isPresent() || !d.getConstrainedContainerElementTypes().isEmpty()) {
                        ValueExtractor<?> declaredTypeValueExtractor = this.context.getValidatorContext().getValueExtractors().find(d.getKey());
                        ExtractValues.extract(this.context, d.getKey(), declaredTypeValueExtractor).stream().filter(e -> !e.isRecursive()).map(e -> this.this$0.new ContainerElementConstraintsFrame(this, (ContainerElementTypeD)d, (GraphContext)e)).forEach(f -> f.validateDescriptorConstraints(groups, sink));
                    }
                });
            }
        }

        @Override
        void recurse(GroupStrategy groups, Consumer<ConstraintViolation<T>> sink) {
            if (this.context.getValue() == null || !DescriptorManager.isCascaded(this.descriptor)) {
                return;
            }
            Map<Group, GroupStrategy> conversions = ((CascadableDescriptor)((Object)this.descriptor)).getGroupConversions().stream().collect(Collectors.toMap(gc -> Group.of(gc.getFrom()), gc -> this.this$0.validatorContext.getGroupsComputer().computeGroups(gc.getTo()).asStrategy()));
            GroupStrategy.redefining(groups, conversions).applyTo(this.this$0.noViolations(gs -> this.cascade((GroupStrategy)gs, sink)));
        }

        private void cascade(GroupStrategy groups, Consumer<ConstraintViolation<T>> sink) {
            ((ContainerDescriptor)((Object)this.descriptor)).getConstrainedContainerElementTypes().stream().filter(d -> d.isCascaded() || !d.getConstrainedContainerElementTypes().isEmpty()).flatMap(d -> ComposedD.unwrap(d, ContainerElementTypeD.class)).forEach(d -> {
                ValueExtractor<?> runtimeTypeValueExtractor = this.context.getValidatorContext().getValueExtractors().find(this.context.runtimeKey(d.getKey()));
                ExtractValues.extract(this.context, d.getKey(), runtimeTypeValueExtractor).stream().filter(e -> !e.isRecursive()).map(e -> this.this$0.new ContainerElementCascadeFrame(this, (ContainerElementTypeD)d, (GraphContext)e)).forEach(f -> f.recurse(groups, sink));
            });
            if (!((CascadableDescriptor)((Object)this.descriptor)).isCascaded()) {
                return;
            }
            if (this.descriptor instanceof PropertyDescriptor) {
                TraversableResolver traversableResolver = this.this$0.validatorContext.getTraversableResolver();
                Object traversableObject = Optional.ofNullable(this.context.getParent()).map(GraphContext::getValue).orElse(null);
                PathImpl pathToTraversableObject = this.context.getPath();
                NodeImpl traversableProperty = pathToTraversableObject.removeLeafNode();
                try {
                    if (!traversableResolver.isCascadable(traversableObject, traversableProperty, this.this$0.getRootBeanClass(), pathToTraversableObject, ((PropertyD)this.descriptor).getElementType())) {
                        return;
                    }
                }
                catch (ValidationException ve) {
                    throw ve;
                }
                catch (Exception e) {
                    throw new ValidationException(e);
                }
            }
            this.multiplex().filter(context -> context.getValue() != null && !context.isRecursive()).map(context -> this.this$0.new BeanFrame(this, (GraphContext)context)).forEach(b -> b.process(groups, sink));
        }

        protected GraphContext getMultiplexContext() {
            return this.context;
        }

        private Stream<GraphContext> multiplex() {
            GraphContext multiplexContext = this.getMultiplexContext();
            Object value = multiplexContext.getValue();
            if (value == null) {
                return Stream.empty();
            }
            if (value.getClass().isArray()) {
                Class arrayType = value instanceof Object[] ? Object[].class : value.getClass();
                return IntStream.range(0, Array.getLength(value)).mapToObj(i -> multiplexContext.child(NodeImpl.atIndex(i).inContainer(arrayType, null), Array.get(value, i)));
            }
            if (Map.class.isInstance(value)) {
                return ((Map)value).entrySet().stream().map(e -> multiplexContext.child(this.setContainerInformation(NodeImpl.atKey(e.getKey()), MAP_VALUE, this.descriptor.getElementClass()), e.getValue()));
            }
            if (List.class.isInstance(value)) {
                List l = (List)value;
                return IntStream.range(0, l.size()).mapToObj(i -> multiplexContext.child(this.setContainerInformation(NodeImpl.atIndex(i), ITERABLE_ELEMENT, this.descriptor.getElementClass()), l.get(i)));
            }
            if (Iterable.class.isInstance(value)) {
                Stream.Builder b = Stream.builder();
                ((Iterable)value).forEach(b);
                return b.build().map(o -> multiplexContext.child(this.setContainerInformation(NodeImpl.atIndex(null), ITERABLE_ELEMENT, this.descriptor.getElementClass()), o));
            }
            return Stream.of(multiplexContext);
        }

        private NodeImpl setContainerInformation(NodeImpl node, TypeVariable<?> originalTypeVariable, Class<?> containerType) {
            Type assignedType;
            TypeVariable tv = containerType.equals(originalTypeVariable.getGenericDeclaration()) ? originalTypeVariable : ((assignedType = TypeUtils.getTypeArguments(containerType, (Class)originalTypeVariable.getGenericDeclaration()).get(originalTypeVariable)) instanceof TypeVariable ? (TypeVariable)assignedType : null);
            int i = tv == null ? -1 : ObjectUtils.indexOf(containerType.getTypeParameters(), tv);
            return node.inContainer(containerType, i < 0 ? null : Integer.valueOf(i));
        }

        @Override
        Object getBean() {
            return Optional.ofNullable(this.parent).map(Frame::getBean).orElse(null);
        }
    }

    public class BeanFrame<B>
    extends Frame<BeanD<B>> {
        private final GraphContext realContext;

        BeanFrame(GraphContext context) {
            this(null, context);
        }

        BeanFrame(Frame<?> parent, GraphContext context) {
            super(ValidationJob.this, parent, ValidationJob.this.getBeanDescriptor(context.getValue()), context.child(context.getPath().addBean(), context.getValue()));
            this.realContext = context;
        }

        @Override
        void process(GroupStrategy groups, Consumer<ConstraintViolation<T>> sink) {
            Validate.notNull(sink, "sink", new Object[0]);
            Lazy<Set> propertyFrames = new Lazy<Set>(this::propertyFrames);
            GroupStrategy localGroupStrategy = GroupStrategy.redefining(groups, Collections.singletonMap(Group.DEFAULT, ((BeanD)this.descriptor).getGroupStrategy()));
            localGroupStrategy.applyTo(ValidationJob.this.noViolations(gs -> {
                this.validateDescriptorConstraints((GroupStrategy)gs, sink);
                ((Set)propertyFrames.get()).forEach(p -> {
                    p.validateDescriptorConstraints((GroupStrategy)gs, sink);
                    if (localGroupStrategy == groups) {
                        p.recurse((GroupStrategy)gs, sink);
                    }
                });
            }));
            if (localGroupStrategy != groups) {
                propertyFrames.get().forEach(p -> p.recurse(groups, sink));
            }
        }

        protected Frame<?> propertyFrame(PropertyD<?> d, GraphContext context) {
            return new SproutFrame(ValidationJob.this, (Frame)this, d, context);
        }

        @Override
        Object getBean() {
            return this.context.getValue();
        }

        private Set<Frame<?>> propertyFrames() {
            Stream<PropertyD> properties = ((BeanD)this.descriptor).getConstrainedProperties().stream().flatMap(d -> ComposedD.unwrap(d, PropertyD.class)).map(d -> d);
            TraversableResolver traversableResolver = ValidationJob.this.validatorContext.getTraversableResolver();
            Stream<PropertyD> reachableProperties = properties.filter(d -> {
                PathImpl p = this.realContext.getPath();
                p.addProperty(d.getPropertyName());
                try {
                    return traversableResolver.isReachable(this.context.getValue(), p.removeLeafNode(), ValidationJob.this.getRootBeanClass(), p, d.getElementType());
                }
                catch (ValidationException ve) {
                    throw ve;
                }
                catch (Exception e) {
                    throw new ValidationException(e);
                }
            });
            return reachableProperties.flatMap(d -> d.read(this.realContext).filter(context -> !context.isRecursive()).map(child -> this.propertyFrame((PropertyD<?>)d, (GraphContext)child))).collect(Collectors.toSet());
        }
    }

    public static abstract class Frame<D extends ElementD<?, ?>> {
        protected final Frame<?> parent;
        protected final D descriptor;
        protected final GraphContext context;
        final /* synthetic */ ValidationJob this$0;

        protected Frame(Frame<?> parent, D descriptor, GraphContext context) {
            this.this$0 = this$0;
            this.parent = parent;
            this.descriptor = (ElementD)Validate.notNull(descriptor, "descriptor", new Object[0]);
            this.context = Validate.notNull(context, "context", new Object[0]);
        }

        protected ValidationTarget getValidationTarget() {
            return ValidationTarget.ANNOTATED_ELEMENT;
        }

        final ValidationJob<T> getJob() {
            return this.this$0;
        }

        void process(GroupStrategy groups, Consumer<ConstraintViolation<T>> sink) {
            Validate.notNull(sink, "sink", new Object[0]);
            GroupStrategy.redefining(groups, Collections.singletonMap(Group.DEFAULT, ((ElementD)this.descriptor).getGroupStrategy())).applyTo(this.this$0.noViolations(gs -> this.validateDescriptorConstraints((GroupStrategy)gs, sink)));
            this.recurse(groups, sink);
        }

        void recurse(GroupStrategy groups, Consumer<ConstraintViolation<T>> sink) {
            throw new UnsupportedOperationException();
        }

        abstract Object getBean();

        void validateDescriptorConstraints(GroupStrategy groups, Consumer<ConstraintViolation<T>> sink) {
            ValidationJob.constraintsFor(this.descriptor, groups).forEach(c -> this.unwrap(c.getValueUnwrapping()).forEach(f -> f.validate((ConstraintD<?>)c, sink)));
        }

        private Stream<Frame<D>> unwrap(ValidateUnwrappedValue valueUnwrapping) {
            Optional<ValueExtractors.UnwrappingInfo> valueExtractorAndAssociatedContainerElementKey;
            if (valueUnwrapping != ValidateUnwrappedValue.SKIP && this.context.getValue() != null && (valueExtractorAndAssociatedContainerElementKey = this.this$0.validatorContext.getValueExtractors().findUnwrappingInfo(this.context.getValue().getClass(), valueUnwrapping)).isPresent()) {
                return ExtractValues.extract(this.context, valueExtractorAndAssociatedContainerElementKey.get().containerElementKey, valueExtractorAndAssociatedContainerElementKey.get().valueExtractor).stream().map(child -> this.this$0.new UnwrappedElementConstraintValidationPseudoFrame(this, (GraphContext)child));
            }
            return Stream.of(this);
        }

        private boolean validate(ConstraintD<?> constraint, Consumer<ConstraintViolation<T>> sink) {
            boolean compositionValid;
            boolean valid;
            ConcurrentMap pathMap = this.this$0.completedValidations.computeIfAbsent(constraint, k -> new ConcurrentSkipListMap(PathImpl.PATH_COMPARATOR));
            Set objectSet = pathMap.computeIfAbsent(this.context.getPath(), p -> Collections.newSetFromMap(new IdentityHashMap()));
            if (!objectSet.add(this.context.getValue())) {
                return true;
            }
            ConstraintValidator constraintValidator = this.getConstraintValidator(constraint);
            ConstraintValidatorContextImpl constraintValidatorContext = new ConstraintValidatorContextImpl(this, constraint);
            if (constraintValidator == null) {
                valid = true;
            } else {
                try {
                    constraintValidator.initialize(constraint.getAnnotation());
                    valid = constraintValidator.isValid(this.context.getValue(), constraintValidatorContext);
                }
                catch (ValidationException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new ValidationException(e);
                }
                if (!valid) {
                    constraintValidatorContext.getRequiredViolations().forEach(sink);
                }
            }
            if (!(!valid && constraint.isReportAsSingleViolation() || (compositionValid = this.validateComposed(constraint, sink)))) {
                if (valid && constraint.isReportAsSingleViolation()) {
                    constraintValidatorContext.getRequiredViolations().forEach(sink);
                }
                return false;
            }
            return valid;
        }

        private boolean validateComposed(ConstraintD<?> constraint, Consumer<ConstraintViolation<T>> sink) {
            if (constraint.getComposingConstraints().isEmpty()) {
                return true;
            }
            Consumer<ConstraintViolation> effectiveSink = constraint.isReportAsSingleViolation() ? cv -> {} : sink;
            Set validationResults = constraint.getComposingConstraints().stream().map(ConstraintD.class::cast).map(c -> this.validate((ConstraintD<?>)c, (Consumer)effectiveSink)).collect(Collectors.toSet());
            return Collections.singleton(Boolean.TRUE).equals(validationResults);
        }

        private ConstraintValidator getConstraintValidator(ConstraintD<?> constraint) {
            return this.this$0.validatorContext.getOrComputeConstraintValidator(constraint, () -> {
                Object constraintValidatorClass = new ComputeConstraintValidatorClass(this.this$0.validatorContext.getConstraintsCache(), constraint, this.getValidationTarget(), this.computeValidatedType(constraint)).get();
                if (constraintValidatorClass == null) {
                    if (constraint.getComposingConstraints().isEmpty()) {
                        Exceptions.raise(UnexpectedTypeException::new, "No %s type located for non-composed constraint %s", ConstraintValidator.class.getSimpleName(), constraint);
                    }
                    return NOOP_VALIDATOR;
                }
                ConstraintValidator constraintValidator = null;
                Exception cause = null;
                try {
                    constraintValidator = (ConstraintValidator)this.this$0.validatorContext.getConstraintValidatorFactory().getInstance(constraintValidatorClass);
                }
                catch (Exception e) {
                    cause = e;
                }
                if (constraintValidator == null) {
                    Exceptions.raise(ValidationException::new, cause, "Unable to get %s instance from %s", ((Class)constraintValidatorClass).getName(), this.this$0.validatorContext.getConstraintValidatorFactory());
                }
                return constraintValidator;
            });
        }

        private Class<?> computeValidatedType(ConstraintD<?> constraint) {
            if (this.context.getValue() != null) {
                return this.context.getValue().getClass();
            }
            Class<?> elementClass = this.descriptor.getElementClass();
            Optional<Class> extractedType = this.this$0.validatorContext.getValueExtractors().findUnwrappingInfo(elementClass, constraint.getValueUnwrapping()).map(info -> ValueExtractors.getExtractedType(info.valueExtractor, elementClass));
            return extractedType.orElse(elementClass);
        }
    }
}

