/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.kit.env.support;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.ZoneId;
import java.time.format.DateTimeParseException;
import java.util.IllformedLocaleException;
import java.util.Locale;
import java.util.Objects;
import java.util.TimeZone;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.kit.env.Log4jProperty;
import org.apache.logging.log4j.kit.env.PropertyEnvironment;
import org.jspecify.annotations.Nullable;

public abstract class BasicPropertyEnvironment
implements PropertyEnvironment {
    private final Logger statusLogger;

    protected BasicPropertyEnvironment(Logger statusLogger) {
        this.statusLogger = statusLogger;
    }

    @Override
    public abstract @Nullable String getProperty(String var1);

    @Override
    public <T> T getProperty(Class<T> propertyClass) {
        if (!propertyClass.isAnnotationPresent(Log4jProperty.class)) {
            throw new IllegalArgumentException("Unsupported configuration properties class '" + propertyClass.getName() + "': missing '@Log4jProperty' annotation.");
        }
        return this.getRecordProperty(null, propertyClass);
    }

    protected Class<?> getClassForName(String className) throws ReflectiveOperationException {
        return Class.forName(className);
    }

    protected Boolean toBoolean(String value) {
        return Boolean.valueOf(value);
    }

    protected @Nullable Charset toCharset(String value) {
        try {
            return "system".equals(value) ? Charset.defaultCharset() : Charset.forName(value);
        }
        catch (UnsupportedOperationException | IllegalCharsetNameException e) {
            this.statusLogger.warn("Invalid Charset value '{}'.", (Object)value, (Object)e);
            return null;
        }
    }

    protected @Nullable Duration toDuration(CharSequence value) {
        try {
            return Duration.parse(value);
        }
        catch (DateTimeParseException e) {
            this.statusLogger.warn("Invalid Duration value '{}'.", (Object)value, (Object)e);
            return null;
        }
    }

    protected char[] toCharArray(String value) {
        return value.toCharArray();
    }

    protected <T> @Nullable Class<? extends T> toClass(String className, Class<T> upperBound) {
        try {
            Class<?> clazz = this.getClassForName(className);
            if (upperBound.isAssignableFrom(clazz)) {
                return clazz;
            }
            this.statusLogger.warn("Invalid Class value '{}': class does not extend {}.", (Object)className, (Object)upperBound.getName());
        }
        catch (ReflectiveOperationException e) {
            this.statusLogger.warn("Invalid Class value '{}'.", (Object)className, (Object)e);
        }
        return null;
    }

    protected <T extends Enum<T>> @Nullable T toEnum(String value, Class<T> enumClass) {
        try {
            return Enum.valueOf(enumClass, value);
        }
        catch (IllegalArgumentException e) {
            this.statusLogger.warn("Invalid enum value '{}' of type {}.", (Object)value, (Object)enumClass.getName(), (Object)e);
            return null;
        }
    }

    protected @Nullable Integer toInteger(String value) {
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            this.statusLogger.warn("Invalid integer value '{}'.", (Object)value, (Object)e);
            return null;
        }
    }

    protected @Nullable Locale toLocale(String value) {
        try {
            if ("system".equals(value)) {
                return Locale.getDefault();
            }
            String languageTag = value.replace('_', '-');
            return new Locale.Builder().setLanguageTag(languageTag).build();
        }
        catch (IllformedLocaleException e) {
            this.statusLogger.warn("Invalid locale value '{}'.", (Object)value, (Object)e);
            return null;
        }
    }

    protected @Nullable Long toLong(String value) {
        try {
            return Long.valueOf(value);
        }
        catch (NumberFormatException e) {
            this.statusLogger.warn("Invalid long value '{}'.", (Object)value, (Object)e);
            return null;
        }
    }

    protected @Nullable Path toPath(String value) {
        try {
            return Paths.get(value, new String[0]);
        }
        catch (InvalidPathException e) {
            this.statusLogger.warn("Invalid path value {}.", (Object)value, (Object)e);
            return null;
        }
    }

    protected @Nullable Level toLevel(String value) {
        return Level.toLevel((String)value, null);
    }

    protected @Nullable TimeZone toTimeZone(String value) {
        ZoneId zoneId = this.toZoneId(value);
        return zoneId != null ? TimeZone.getTimeZone(zoneId) : null;
    }

    protected @Nullable URI toURI(String value) {
        try {
            return new URI(value);
        }
        catch (URISyntaxException e) {
            this.statusLogger.warn("Invalid URI value {}.", (Object)value, (Object)e);
            return null;
        }
    }

    protected @Nullable ZoneId toZoneId(String value) {
        try {
            return "system".equals(value) ? ZoneId.systemDefault() : ZoneId.of(value);
        }
        catch (DateTimeException e) {
            this.statusLogger.warn("Invalid timezone id value '{}'.", (Object)value, (Object)e);
            return null;
        }
    }

    private <T> T getRecordProperty(@Nullable String parentPrefix, Class<T> propertyClass) {
        if (!propertyClass.isRecord()) {
            throw new IllegalArgumentException("Unsupported configuration properties class '" + propertyClass.getName() + "': class is not a record.");
        }
        String prefix = parentPrefix != null ? parentPrefix : this.getPropertyName(propertyClass, propertyClass::getSimpleName);
        Constructor<?>[] constructors = propertyClass.getDeclaredConstructors();
        if (constructors.length == 0) {
            throw new IllegalArgumentException("Unsupported configuration properties class '" + propertyClass.getName() + "': missing public constructor.");
        }
        if (constructors.length > 1) {
            throw new IllegalArgumentException("Unsupported configuration properties class '" + propertyClass.getName() + "': more than one constructor found.");
        }
        Constructor<?> constructor = constructors[0];
        Parameter[] parameters = constructor.getParameters();
        @Nullable Object[] initArgs = new Object[parameters.length];
        for (int i = 0; i < initArgs.length; ++i) {
            String name = prefix + "." + this.getPropertyName(parameters[i], parameters[i]::getName);
            String defaultValue = this.getPropertyDefaultAsString(parameters[i]);
            initArgs[i] = this.getObjectProperty(name, parameters[i].getParameterizedType(), defaultValue);
        }
        try {
            return (T)constructor.newInstance(initArgs);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException("Unable to parse configuration properties class " + propertyClass.getName() + ".", e);
        }
    }

    private @Nullable Object getObjectProperty(String name, Type type, @Nullable String defaultValue) {
        ParameterizedType parameterizedType;
        if (type instanceof ParameterizedType && (parameterizedType = (ParameterizedType)type).getRawType().equals(Class.class)) {
            Type[] arguments = parameterizedType.getActualTypeArguments();
            Class<Object> upperBound = arguments.length > 0 ? this.findUpperBound(arguments[0]) : Object.class;
            return this.getObjectPropertyWithStringDefault(name, defaultValue, className -> this.toClass((String)className, (Class)upperBound));
        }
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (clazz.isRecord()) {
                return this.getRecordProperty(name, clazz);
            }
            if (char[].class.equals((Object)clazz)) {
                return this.getObjectPropertyWithStringDefault(name, defaultValue, this::toCharArray);
            }
            if (Boolean.TYPE.equals(clazz)) {
                return this.getObjectPropertyWithStringDefault(name, Objects.toString(defaultValue, "false"), this::toBoolean);
            }
            if (Boolean.class.equals((Object)clazz)) {
                return this.getObjectPropertyWithStringDefault(name, defaultValue, this::toBoolean);
            }
            if (Charset.class.equals((Object)clazz)) {
                return this.getObjectPropertyWithStringDefault(name, defaultValue, this::toCharset);
            }
            if (Duration.class.equals((Object)clazz)) {
                return this.getObjectPropertyWithStringDefault(name, defaultValue, this::toDuration);
            }
            if (Enum.class.isAssignableFrom(clazz)) {
                return this.getObjectPropertyWithStringDefault(name, defaultValue, value -> this.toEnum((String)value, clazz));
            }
            if (Integer.TYPE.equals(clazz)) {
                return this.getObjectPropertyWithStringDefault(name, Objects.toString(defaultValue, "0"), this::toInteger);
            }
            if (Integer.class.equals((Object)clazz)) {
                return this.getObjectPropertyWithStringDefault(name, defaultValue, this::toInteger);
            }
            if (Locale.class.equals((Object)clazz)) {
                return this.getObjectPropertyWithStringDefault(name, defaultValue, this::toLocale);
            }
            if (Long.TYPE.equals(clazz)) {
                return this.getObjectPropertyWithStringDefault(name, Objects.toString(defaultValue, "0"), this::toLong);
            }
            if (Long.class.equals((Object)clazz)) {
                return this.getObjectPropertyWithStringDefault(name, defaultValue, this::toLong);
            }
            if (Level.class.equals((Object)clazz)) {
                return this.getObjectPropertyWithStringDefault(name, defaultValue, this::toLevel);
            }
            if (Path.class.equals((Object)clazz)) {
                return this.getObjectPropertyWithStringDefault(name, defaultValue, this::toPath);
            }
            if (TimeZone.class.equals((Object)clazz)) {
                return this.getObjectPropertyWithStringDefault(name, defaultValue, this::toTimeZone);
            }
            if (URI.class.equals((Object)clazz)) {
                return this.getObjectPropertyWithStringDefault(name, defaultValue, this::toURI);
            }
            if (ZoneId.class.equals((Object)clazz)) {
                return this.getObjectPropertyWithStringDefault(name, defaultValue, this::toZoneId);
            }
            if (String.class.equals((Object)clazz)) {
                return this.getObjectPropertyWithStringDefault(name, defaultValue, x -> x);
            }
        }
        throw new IllegalArgumentException("Unsupported property of type '" + type.getTypeName() + "'");
    }

    private Class<?> findUpperBound(Type type) {
        Class clazz;
        Type type2;
        Type[] bounds;
        if (type instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)type;
            bounds = typeVariable.getBounds();
        } else if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            bounds = wildcardType.getUpperBounds();
        } else {
            bounds = new Type[]{};
        }
        return bounds.length > 0 && (type2 = bounds[0]) instanceof Class ? (clazz = (Class)type2) : Object.class;
    }

    private String getPropertyName(AnnotatedElement element, Supplier<String> fallback) {
        String specifiedName;
        if (element.isAnnotationPresent(Log4jProperty.class) && !(specifiedName = element.getAnnotation(Log4jProperty.class).name()).isEmpty()) {
            return specifiedName;
        }
        return fallback.get();
    }

    private @Nullable String getPropertyDefaultAsString(AnnotatedElement parameter) {
        String defaultValue;
        if (parameter.isAnnotationPresent(Log4jProperty.class) && !(defaultValue = parameter.getAnnotation(Log4jProperty.class).defaultValue()).isEmpty()) {
            return defaultValue;
        }
        return null;
    }

    private <T> @Nullable Object getObjectPropertyWithStringDefault(String name, @Nullable String defaultValue, Function<? super String, ?> converter) {
        Object value;
        String prop = this.getProperty(name);
        if (prop != null && (value = converter.apply(prop)) != null) {
            return value;
        }
        return defaultValue != null ? converter.apply(defaultValue) : null;
    }
}

