/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.test.net.ssl;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.logging.log4j.core.test.net.ssl.TlsSyslogInputStreamReaderBase;
import org.apache.logging.log4j.core.test.net.ssl.TlsSyslogMessageFormat;

public class LegacyBsdTlsSyslogInputStreamReader
extends TlsSyslogInputStreamReaderBase {
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();

    public LegacyBsdTlsSyslogInputStreamReader(InputStream inputStream) {
        super(inputStream, TlsSyslogMessageFormat.LEGACY_BSD);
    }

    @Override
    public String read() throws IOException {
        String message = "";
        try {
            int b;
            do {
                if ((b = this.inputStream.read()) == -1) {
                    throw new EOFException("The stream has been closed or the end of stream has been reached");
                }
                this.buffer.write(b);
            } while (b != 10);
        }
        catch (EOFException e) {
            if (this.buffer.size() > 0) {
                message = this.buffer.toString();
                this.buffer.reset();
                return message;
            }
            throw e;
        }
        message = this.buffer.toString();
        this.buffer.reset();
        return message;
    }
}

