/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.test.layout;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.test.categories.Layouts;
import org.apache.logging.log4j.core.test.junit.CleanFolders;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={Layouts.Csv.class})
public abstract class Log4j2_1482_Test {
    static final String CONFIG_LOCATION = "log4j2-1482.xml";
    static final String FOLDER = "target/log4j2-1482";
    private static final int LOOP_COUNT = 10;
    @Rule
    public CleanFolders cleanFolders = new CleanFolders("target/log4j2-1482");

    static void assertFileContents(int runNumber) throws IOException {
        Path path = Paths.get("target/log4j2-1482/audit.tmp", new String[0]);
        List<String> lines = Files.readAllLines(path, Charset.defaultCharset());
        int i = 1;
        int size = lines.size();
        for (String string : lines) {
            if (!string.startsWith(",,")) continue;
            Path folder = Paths.get(FOLDER, new String[0]);
            Object[] files = folder.toFile().listFiles();
            Arrays.sort(files);
            System.out.println("Run " + runNumber + ": " + Arrays.toString(files));
            Assert.fail((String)String.format("Run %,d, line %,d of %,d: \"%s\" in %s", runNumber, i++, size, string, lines));
        }
    }

    protected abstract void log(int var1);

    private void loopingRun(int loopCount) throws IOException {
        for (int i = 1; i <= loopCount; ++i) {
            try (LoggerContext loggerContext = Configurator.initialize((String)this.getClass().getName(), (String)CONFIG_LOCATION);){
                this.log(i);
            }
            Log4j2_1482_Test.assertFileContents(i);
        }
    }

    @Test
    public void testLoopingRun() throws IOException {
        this.loopingRun(10);
    }

    @Test
    public void testSingleRun() throws IOException {
        this.loopingRun(1);
    }
}

