/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.web;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LifeCycle2;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.Strings;
import org.apache.logging.log4j.web.Log4jShutdownOnContextDestroyedListener;
import org.apache.logging.log4j.web.Log4jWebLifeCycle;
import org.apache.logging.log4j.web.WebLoggerContextUtils;

public class Log4jServletContextListener
implements ServletContextListener {
    static final String START_COUNT_ATTR = Log4jServletContextListener.class.getName() + ".START_COUNT";
    private static final int DEFAULT_STOP_TIMEOUT = 30;
    private static final TimeUnit DEFAULT_STOP_TIMEOUT_TIMEUNIT = TimeUnit.SECONDS;
    private static final String KEY_STOP_TIMEOUT = "log4j.stop.timeout";
    private static final String KEY_STOP_TIMEOUT_TIMEUNIT = "log4j.stop.timeout.timeunit";
    private static final Logger LOGGER = StatusLogger.getLogger();
    private ServletContext servletContext;
    private Log4jWebLifeCycle initializer;

    private int getAndIncrementCount() {
        Integer count = (Integer)this.servletContext.getAttribute(START_COUNT_ATTR);
        if (count == null) {
            count = 0;
        }
        this.servletContext.setAttribute(START_COUNT_ATTR, (Object)(count + 1));
        return count;
    }

    private int decrementAndGetCount() {
        Integer count = (Integer)this.servletContext.getAttribute(START_COUNT_ATTR);
        if (count == null) {
            LOGGER.warn("{} received a 'contextDestroyed' message without a corresponding 'contextInitialized' message.", (Object)this.getClass().getName());
            count = 1;
        }
        count = count - 1;
        this.servletContext.setAttribute(START_COUNT_ATTR, (Object)count);
        return count;
    }

    public void contextInitialized(ServletContextEvent event) {
        this.servletContext = event.getServletContext();
        if ("true".equalsIgnoreCase(this.servletContext.getInitParameter("isLog4jAutoShutdownDisabled"))) {
            throw new IllegalStateException("Do not use " + this.getClass().getSimpleName() + " when " + "isLog4jAutoShutdownDisabled" + " is true. Please use " + Log4jShutdownOnContextDestroyedListener.class.getSimpleName() + " instead of " + this.getClass().getSimpleName() + ".");
        }
        this.initializer = WebLoggerContextUtils.getWebLifeCycle(this.servletContext);
        if (this.getAndIncrementCount() != 0) {
            LOGGER.debug("Skipping Log4j context initialization, since {} is registered multiple times.", (Object)this.getClass().getSimpleName());
            return;
        }
        LOGGER.info("{} triggered a Log4j context initialization.", (Object)this.getClass().getSimpleName());
        try {
            this.initializer.start();
            this.initializer.setLoggerContext();
        }
        catch (IllegalStateException e) {
            throw new IllegalStateException("Failed to initialize Log4j properly.", e);
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        if (this.servletContext == null || this.initializer == null) {
            LOGGER.warn("Servlet context destroyed before it was initialized.");
            return;
        }
        if (this.decrementAndGetCount() != 0) {
            LOGGER.debug("Skipping Log4j context shutdown, since {} is registered multiple times.", (Object)this.getClass().getSimpleName());
            return;
        }
        LOGGER.info("{} triggered a Log4j context shutdown.", (Object)this.getClass().getSimpleName());
        try {
            this.initializer.clearLoggerContext();
            if (this.initializer instanceof LifeCycle2) {
                String stopTimeoutStr = this.servletContext.getInitParameter(KEY_STOP_TIMEOUT);
                long stopTimeout = Strings.isEmpty((CharSequence)stopTimeoutStr) ? 30L : Long.parseLong(stopTimeoutStr);
                String timeoutTimeUnitStr = this.servletContext.getInitParameter(KEY_STOP_TIMEOUT_TIMEUNIT);
                TimeUnit timeoutTimeUnit = Strings.isEmpty((CharSequence)timeoutTimeUnitStr) ? DEFAULT_STOP_TIMEOUT_TIMEUNIT : TimeUnit.valueOf(Strings.toRootUpperCase((String)timeoutTimeUnitStr));
                ((LifeCycle2)this.initializer).stop(stopTimeout, timeoutTimeUnit);
            } else {
                this.initializer.stop();
            }
        }
        catch (IllegalStateException e) {
            throw new IllegalStateException("Failed to shutdown Log4j properly.", e);
        }
    }
}

