/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.observation.impl;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import java.io.IOException;
import java.net.URISyntaxException;
import org.apache.hc.client5.http.classic.ExecChain;
import org.apache.hc.client5.http.classic.ExecChainHandler;
import org.apache.hc.client5.http.observation.ObservingOptions;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.util.Args;

public final class ObservationClassicExecInterceptor
implements ExecChainHandler {
    private final ObservationRegistry registry;
    private final ObservingOptions opts;

    public ObservationClassicExecInterceptor(ObservationRegistry registry, ObservingOptions opts) {
        this.registry = (ObservationRegistry)Args.notNull((Object)registry, (String)"observationRegistry");
        this.opts = opts != null ? opts : ObservingOptions.DEFAULT;
    }

    public ClassicHttpResponse execute(ClassicHttpRequest request, ExecChain.Scope scope, ExecChain chain) throws IOException, HttpException {
        if (!this.opts.spanSampling.test(request.getRequestUri())) {
            return chain.proceed(request, scope);
        }
        String method = request.getMethod();
        String uriForName = ObservationClassicExecInterceptor.safeUriForName(request);
        String peer = request.getAuthority().getHostName();
        Observation obs = Observation.createNotStarted((String)"http.client.request", (ObservationRegistry)this.registry).contextualName(method + " " + uriForName).lowCardinalityKeyValue("http.method", method).lowCardinalityKeyValue("net.peer.name", peer).start();
        ClassicHttpResponse response = null;
        Throwable error = null;
        try {
            ClassicHttpResponse classicHttpResponse = response = chain.proceed(request, scope);
            return classicHttpResponse;
        }
        catch (Throwable t) {
            error = t;
            throw t;
        }
        finally {
            if (response != null) {
                obs.lowCardinalityKeyValue("http.status_code", Integer.toString(response.getCode()));
            }
            if (this.opts.tagLevel == ObservingOptions.TagLevel.EXTENDED) {
                obs.lowCardinalityKeyValue("http.scheme", scope.route.getTargetHost().getSchemeName()).lowCardinalityKeyValue("net.peer.name", scope.route.getTargetHost().getHostName());
            }
            if (error != null) {
                obs.error(error);
            }
            obs.stop();
        }
    }

    private static String safeUriForName(ClassicHttpRequest req) {
        try {
            return req.getUri().toString();
        }
        catch (URISyntaxException e) {
            return req.getRequestUri();
        }
    }
}

