/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.commons;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.exceptions.NotSupportedException;

public class ArraySet<E>
extends ArrayList<E>
implements Set<E> {
    private static final long serialVersionUID = 1L;

    public ArraySet() {
    }

    public ArraySet(int initialCapacity) {
        super(initialCapacity);
    }

    @SafeVarargs
    public ArraySet(E ... items) {
        super(items.length);
        for (int i = 0; i < items.length; ++i) {
            this.add(items[i]);
        }
    }

    public ArraySet(ArraySet<E> other) {
        super(other.size());
        for (Object e : other) {
            this.add(e);
        }
    }

    public Set<E> immutable() {
        return new ImmutableArraySet();
    }

    @Override
    public boolean add(E e) {
        if (e == null || this.contains(e)) {
            return false;
        }
        return super.add(e);
    }

    @Override
    public void add(int index, E element) {
        if (element == null) {
            return;
        }
        this.remove(element);
        super.add(index, element);
    }

    @Override
    public int indexOf(Object item) {
        if (item instanceof Object[]) {
            return this.indexOfArray((Object[])item);
        }
        return super.indexOf(item);
    }

    @Override
    public int lastIndexOf(Object item) {
        if (item instanceof Object[]) {
            return this.indexOfArray((Object[])item);
        }
        return super.lastIndexOf(item);
    }

    @Override
    public boolean remove(Object item) {
        if (item instanceof Object[]) {
            int index = this.indexOfArray((Object[])item);
            if (index >= 0) {
                this.remove(index);
            }
            return index >= 0;
        }
        return super.remove(item);
    }

    @Override
    public String toString() {
        return StringUtils.listToString(this, StringUtils.LIST_TEMPLATE);
    }

    protected void fastAdd(E element) {
        super.add(element);
    }

    protected void fastAdd(int index, E element) {
        super.add(index, element);
    }

    protected int indexOfArray(Object[] item) {
        for (int i = 0; i < this.size(); ++i) {
            Object element = this.get(i);
            if (!(element instanceof Object[]) || !ObjectUtils.compareEqual(item, (Object[])element)) continue;
            return i;
        }
        return -1;
    }

    private class ImmutableArraySet<E>
    implements Set<E> {
        private ImmutableArraySet() {
        }

        public Object clone() {
            return new ArraySet(ArraySet.this);
        }

        @Override
        public int size() {
            return ArraySet.this.size();
        }

        @Override
        public boolean isEmpty() {
            return ArraySet.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return ArraySet.this.contains(o);
        }

        @Override
        public Iterator<E> iterator() {
            return ArraySet.this.iterator();
        }

        @Override
        public Object[] toArray() {
            return ArraySet.this.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return ArraySet.this.toArray(a);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return ArraySet.this.containsAll(c);
        }

        @Override
        public boolean add(E e) {
            throw new NotSupportedException(this, "set");
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            throw new NotSupportedException(this, "addAll");
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new NotSupportedException(this, "retainAll");
        }

        @Override
        public boolean remove(Object o) {
            throw new NotSupportedException(this, "remove");
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new NotSupportedException(this, "removeAll");
        }

        @Override
        public void clear() {
            throw new NotSupportedException(this, "clear");
        }
    }
}

