/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.undo;

import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.apache.cayenne.modeler.action.CreateCallbackMethodAction;
import org.apache.cayenne.modeler.action.RemoveCallbackMethodAction;
import org.apache.cayenne.modeler.editor.CallbackType;
import org.apache.cayenne.modeler.undo.CayenneUndoableEdit;

public class CreateCallbackMethodUndoableEdit
extends CayenneUndoableEdit {
    private CallbackType callbackType;
    private String methodName;

    @Override
    public String getPresentationName() {
        return "Create Callback Method";
    }

    @Override
    public void redo() throws CannotRedoException {
        CreateCallbackMethodAction action = this.actionManager.getAction(CreateCallbackMethodAction.class);
        action.createCallbackMethod(this.callbackType, this.methodName);
    }

    @Override
    public void undo() throws CannotUndoException {
        RemoveCallbackMethodAction action = this.actionManager.getAction(RemoveCallbackMethodAction.class);
        action.removeCallbackMethod(this.callbackType, this.methodName);
    }

    public CreateCallbackMethodUndoableEdit(CallbackType callbackType, String methodName) {
        this.callbackType = callbackType;
        this.methodName = methodName;
    }
}

