/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.springrabbitmqsink;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSinkConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelSpringrabbitmqsinkSinkConnectorConfig
        extends
            CamelSinkConnectorConfig {

    public static final String CAMEL_SINK_SPRINGRABBITMQSINK_KAMELET_HOST_CONF = "camel.kamelet.spring-rabbitmq-sink.host";
    public static final String CAMEL_SINK_SPRINGRABBITMQSINK_KAMELET_HOST_DOC = "RabbitMQ broker address Example: localhost";
    public static final String CAMEL_SINK_SPRINGRABBITMQSINK_KAMELET_HOST_DEFAULT = null;
    public static final String CAMEL_SINK_SPRINGRABBITMQSINK_KAMELET_PORT_CONF = "camel.kamelet.spring-rabbitmq-sink.port";
    public static final String CAMEL_SINK_SPRINGRABBITMQSINK_KAMELET_PORT_DOC = "RabbitMQ broker port Example: 5672";
    public static final Integer CAMEL_SINK_SPRINGRABBITMQSINK_KAMELET_PORT_DEFAULT = null;
    public static final String CAMEL_SINK_SPRINGRABBITMQSINK_KAMELET_ROUTING_KEY_CONF = "camel.kamelet.spring-rabbitmq-sink.routingKey";
    public static final String CAMEL_SINK_SPRINGRABBITMQSINK_KAMELET_ROUTING_KEY_DOC = "The routing key to use when binding a consumer queue to the exchange";
    public static final String CAMEL_SINK_SPRINGRABBITMQSINK_KAMELET_ROUTING_KEY_DEFAULT = null;
    public static final String CAMEL_SINK_SPRINGRABBITMQSINK_KAMELET_USERNAME_CONF = "camel.kamelet.spring-rabbitmq-sink.username";
    public static final String CAMEL_SINK_SPRINGRABBITMQSINK_KAMELET_USERNAME_DOC = "The username to access the RabbitMQ server";
    public static final String CAMEL_SINK_SPRINGRABBITMQSINK_KAMELET_USERNAME_DEFAULT = null;
    public static final String CAMEL_SINK_SPRINGRABBITMQSINK_KAMELET_PASSWORD_CONF = "camel.kamelet.spring-rabbitmq-sink.password";
    public static final String CAMEL_SINK_SPRINGRABBITMQSINK_KAMELET_PASSWORD_DOC = "The password to access the RabbitMQ server";
    public static final String CAMEL_SINK_SPRINGRABBITMQSINK_KAMELET_PASSWORD_DEFAULT = null;
    public static final String CAMEL_SINK_SPRINGRABBITMQSINK_KAMELET_EXCHANGE_NAME_CONF = "camel.kamelet.spring-rabbitmq-sink.exchangeName";
    public static final String CAMEL_SINK_SPRINGRABBITMQSINK_KAMELET_EXCHANGE_NAME_DOC = "The exchange name determines the exchange the queue will be bound to";
    public static final String CAMEL_SINK_SPRINGRABBITMQSINK_KAMELET_EXCHANGE_NAME_DEFAULT = null;
    public static final String CAMEL_SINK_SPRINGRABBITMQSINK_KAMELET_QUEUES_CONF = "camel.kamelet.spring-rabbitmq-sink.queues";
    public static final String CAMEL_SINK_SPRINGRABBITMQSINK_KAMELET_QUEUES_DOC = "The queue to receive messages from";
    public static final String CAMEL_SINK_SPRINGRABBITMQSINK_KAMELET_QUEUES_DEFAULT = null;
    public static final String CAMEL_SINK_SPRINGRABBITMQSINK_KAMELET_AUTO_DECLARE_PRODUCER_CONF = "camel.kamelet.spring-rabbitmq-sink.autoDeclareProducer";
    public static final String CAMEL_SINK_SPRINGRABBITMQSINK_KAMELET_AUTO_DECLARE_PRODUCER_DOC = "Specifies whether the producer should auto declare binding between exchange, queue and routing key when starting";
    public static final Boolean CAMEL_SINK_SPRINGRABBITMQSINK_KAMELET_AUTO_DECLARE_PRODUCER_DEFAULT = false;
    public static final String CAMEL_SINK_SPRINGRABBITMQSINK_KAMELET_VHOST_CONF = "camel.kamelet.spring-rabbitmq-sink.vhost";
    public static final String CAMEL_SINK_SPRINGRABBITMQSINK_KAMELET_VHOST_DOC = "The virtual host";
    public static final String CAMEL_SINK_SPRINGRABBITMQSINK_KAMELET_VHOST_DEFAULT = "/";

    public CamelSpringrabbitmqsinkSinkConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelSpringrabbitmqsinkSinkConnectorConfig(
            Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSinkConnectorConfig.conf());
        conf.define(CAMEL_SINK_SPRINGRABBITMQSINK_KAMELET_HOST_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SPRINGRABBITMQSINK_KAMELET_HOST_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_SPRINGRABBITMQSINK_KAMELET_HOST_DOC);
        conf.define(CAMEL_SINK_SPRINGRABBITMQSINK_KAMELET_PORT_CONF, ConfigDef.Type.INT, CAMEL_SINK_SPRINGRABBITMQSINK_KAMELET_PORT_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_SPRINGRABBITMQSINK_KAMELET_PORT_DOC);
        conf.define(CAMEL_SINK_SPRINGRABBITMQSINK_KAMELET_ROUTING_KEY_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SPRINGRABBITMQSINK_KAMELET_ROUTING_KEY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SPRINGRABBITMQSINK_KAMELET_ROUTING_KEY_DOC);
        conf.define(CAMEL_SINK_SPRINGRABBITMQSINK_KAMELET_USERNAME_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SPRINGRABBITMQSINK_KAMELET_USERNAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SPRINGRABBITMQSINK_KAMELET_USERNAME_DOC);
        conf.define(CAMEL_SINK_SPRINGRABBITMQSINK_KAMELET_PASSWORD_CONF, ConfigDef.Type.PASSWORD, CAMEL_SINK_SPRINGRABBITMQSINK_KAMELET_PASSWORD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SPRINGRABBITMQSINK_KAMELET_PASSWORD_DOC);
        conf.define(CAMEL_SINK_SPRINGRABBITMQSINK_KAMELET_EXCHANGE_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SPRINGRABBITMQSINK_KAMELET_EXCHANGE_NAME_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_SPRINGRABBITMQSINK_KAMELET_EXCHANGE_NAME_DOC);
        conf.define(CAMEL_SINK_SPRINGRABBITMQSINK_KAMELET_QUEUES_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SPRINGRABBITMQSINK_KAMELET_QUEUES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SPRINGRABBITMQSINK_KAMELET_QUEUES_DOC);
        conf.define(CAMEL_SINK_SPRINGRABBITMQSINK_KAMELET_AUTO_DECLARE_PRODUCER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_SPRINGRABBITMQSINK_KAMELET_AUTO_DECLARE_PRODUCER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SPRINGRABBITMQSINK_KAMELET_AUTO_DECLARE_PRODUCER_DOC);
        conf.define(CAMEL_SINK_SPRINGRABBITMQSINK_KAMELET_VHOST_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SPRINGRABBITMQSINK_KAMELET_VHOST_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SPRINGRABBITMQSINK_KAMELET_VHOST_DOC);
        return conf;
    }
}