/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.ConstantTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.GValueConstantTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.GValue;
import org.apache.tinkerpop.gremlin.process.traversal.step.GValueHolder;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.FlatMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.MergeStepContract;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.GValueHelper;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.CallbackRegistry;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.Event;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;

public abstract class AbstractMergeElementStepPlaceholder<S, E>
extends FlatMapStep<S, E>
implements MergeStepContract<S, E, Map>,
GValueHolder<S, E> {
    protected final boolean isStart;
    protected Map<Object, List<Object>> properties = new HashMap<Object, List<Object>>();
    protected Traversal.Admin<?, Map<Object, Object>> mergeTraversal;
    protected Traversal.Admin<?, Map<Object, Object>> onCreateTraversal;
    protected Traversal.Admin<?, Map<Object, Object>> onMatchTraversal;

    public AbstractMergeElementStepPlaceholder(Traversal.Admin traversal, Traversal.Admin<?, Map<Object, Object>> mergeTraversal, boolean isStart) {
        super(traversal);
        this.mergeTraversal = mergeTraversal;
        this.integrateChild(mergeTraversal);
        this.isStart = isStart;
    }

    @Override
    protected Iterator<E> flatMap(Traverser.Admin<S> traverser) {
        throw new IllegalStateException("GValuePlaceholder step is not executable");
    }

    @Override
    public AbstractMergeElementStepPlaceholder<S, E> clone() {
        AbstractMergeElementStepPlaceholder clone = (AbstractMergeElementStepPlaceholder)super.clone();
        if (this.mergeTraversal != null) {
            clone.setMerge(this.mergeTraversal.clone());
        }
        if (this.onMatchTraversal != null) {
            clone.setOnMatch(this.onMatchTraversal.clone());
        }
        if (this.onCreateTraversal != null) {
            clone.setOnCreate(this.onCreateTraversal.clone());
        }
        clone.properties = new HashMap<Object, List<Object>>();
        for (Map.Entry<Object, List<Object>> entry : this.properties.entrySet()) {
            Object key = entry.getKey();
            List<Object> oldValues = entry.getValue();
            ArrayList<Object> newValues = new ArrayList<Object>(oldValues.size());
            for (Object v : oldValues) {
                if (v instanceof Traversal) {
                    newValues.add(((Traversal)v).asAdmin().clone());
                    continue;
                }
                if (v instanceof GValue) {
                    newValues.add(((GValue)v).clone());
                    continue;
                }
                newValues.add(v);
            }
            clone.properties.put(key, newValues);
        }
        return clone;
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return super.getRequirements();
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
        this.getLocalChildren().forEach(this::integrateChild);
    }

    public List<Traversal.Admin<?, ?>> getLocalChildren() {
        ArrayList localChildren = new ArrayList();
        if (this.mergeTraversal != null) {
            localChildren.add(this.mergeTraversal);
        }
        if (this.onCreateTraversal != null) {
            localChildren.add(this.onCreateTraversal);
        }
        if (this.onMatchTraversal != null) {
            localChildren.add(this.onMatchTraversal);
        }
        return localChildren;
    }

    @Override
    public Traversal.Admin getMergeTraversal() {
        if (this.mergeTraversal != null && this.mergeTraversal instanceof GValueConstantTraversal) {
            this.traversal.getGValueManager().pinVariable(((GValueConstantTraversal)this.mergeTraversal).getGValue().getName());
            return ((GValueConstantTraversal)this.mergeTraversal).getConstantTraversal();
        }
        return this.mergeTraversal;
    }

    @Override
    public Object getMergeMapWithGValue() {
        if (this.mergeTraversal == null) {
            return null;
        }
        if (this.mergeTraversal instanceof GValueConstantTraversal) {
            return ((GValueConstantTraversal)this.mergeTraversal).getGValue();
        }
        if (this.mergeTraversal instanceof ConstantTraversal) {
            return this.mergeTraversal.next();
        }
        return this.mergeTraversal;
    }

    @Override
    public Traversal.Admin getOnCreateTraversal() {
        if (this.onCreateTraversal != null && this.onCreateTraversal instanceof GValueConstantTraversal) {
            this.traversal.getGValueManager().pinVariable(((GValueConstantTraversal)this.onCreateTraversal).getGValue().getName());
            return ((GValueConstantTraversal)this.onCreateTraversal).getConstantTraversal();
        }
        return this.onCreateTraversal;
    }

    @Override
    public Object getOnCreateMapWithGValue() {
        if (this.onCreateTraversal == null) {
            return null;
        }
        if (this.onCreateTraversal instanceof GValueConstantTraversal) {
            return ((GValueConstantTraversal)this.onCreateTraversal).getGValue();
        }
        if (this.onCreateTraversal instanceof ConstantTraversal) {
            return this.onCreateTraversal.next();
        }
        return this.onCreateTraversal;
    }

    @Override
    public Traversal.Admin getOnMatchTraversal() {
        if (this.onMatchTraversal != null && this.onMatchTraversal instanceof GValueConstantTraversal) {
            this.traversal.getGValueManager().pinVariable(((GValueConstantTraversal)this.onMatchTraversal).getGValue().getName());
            return ((GValueConstantTraversal)this.onMatchTraversal).getConstantTraversal();
        }
        return this.onMatchTraversal;
    }

    @Override
    public Object getOnMatchMapWithGValue() {
        if (this.onMatchTraversal == null) {
            return null;
        }
        if (this.onMatchTraversal instanceof GValueConstantTraversal) {
            return ((GValueConstantTraversal)this.onMatchTraversal).getGValue();
        }
        if (this.onMatchTraversal instanceof ConstantTraversal) {
            return this.onMatchTraversal.next();
        }
        return this.onMatchTraversal;
    }

    @Override
    public boolean isStart() {
        return this.isStart;
    }

    @Override
    public boolean isFirst() {
        return true;
    }

    @Override
    public boolean isUsingPartitionStrategy() {
        return false;
    }

    @Override
    public void setOnMatch(Traversal.Admin<?, Map<Object, Object>> onMatchTraversal) {
        this.onMatchTraversal = onMatchTraversal;
        if (onMatchTraversal instanceof GValueConstantTraversal && ((GValueConstantTraversal)onMatchTraversal).isParameterized()) {
            this.traversal.getGValueManager().register(((GValueConstantTraversal)onMatchTraversal).getGValue());
        }
        this.integrateChild(onMatchTraversal);
    }

    @Override
    public void setOnCreate(Traversal.Admin<?, Map<Object, Object>> onCreateTraversal) {
        this.onCreateTraversal = onCreateTraversal;
        if (onCreateTraversal instanceof GValueConstantTraversal && ((GValueConstantTraversal)onCreateTraversal).isParameterized()) {
            this.traversal.getGValueManager().register(((GValueConstantTraversal)onCreateTraversal).getGValue());
        }
        this.integrateChild(onCreateTraversal);
    }

    @Override
    public void setMerge(Traversal.Admin<?, Map<Object, Object>> mergeTraversal) {
        this.mergeTraversal = mergeTraversal;
        if (mergeTraversal instanceof GValueConstantTraversal && ((GValueConstantTraversal)mergeTraversal).isParameterized()) {
            this.traversal.getGValueManager().register(((GValueConstantTraversal)mergeTraversal).getGValue());
        }
        this.integrateChild(mergeTraversal);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AbstractMergeElementStepPlaceholder that = (AbstractMergeElementStepPlaceholder)o;
        return this.isStart == that.isStart && Objects.equals(this.properties, that.properties) && Objects.equals(this.mergeTraversal, that.mergeTraversal) && Objects.equals(this.onCreateTraversal, that.onCreateTraversal) && Objects.equals(this.onMatchTraversal, that.onMatchTraversal);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.properties, this.mergeTraversal, this.onCreateTraversal, this.onMatchTraversal, this.isStart);
    }

    @Override
    public boolean isParameterized() {
        return this.onMatchTraversal instanceof GValueConstantTraversal && ((GValueConstantTraversal)this.onMatchTraversal).isParameterized() || this.onCreateTraversal instanceof GValueConstantTraversal && ((GValueConstantTraversal)this.onCreateTraversal).isParameterized() || this.mergeTraversal instanceof GValueConstantTraversal && ((GValueConstantTraversal)this.mergeTraversal).isParameterized();
    }

    @Override
    public void updateVariable(String name, Object value) {
        if (this.mergeTraversal != null && this.mergeTraversal instanceof GValueConstantTraversal) {
            ((GValueConstantTraversal)this.mergeTraversal).updateVariable(name, value);
        }
        if (this.onMatchTraversal != null && this.onMatchTraversal instanceof GValueConstantTraversal) {
            ((GValueConstantTraversal)this.onMatchTraversal).updateVariable(name, value);
        }
        if (this.onCreateTraversal != null && this.onCreateTraversal instanceof GValueConstantTraversal) {
            ((GValueConstantTraversal)this.onCreateTraversal).updateVariable(name, value);
        }
    }

    @Override
    public Collection<GValue<?>> getGValues() {
        HashSet gValues = new HashSet();
        if (this.mergeTraversal instanceof GValueConstantTraversal && ((GValueConstantTraversal)this.mergeTraversal).getGValue().isVariable()) {
            gValues.add(((GValueConstantTraversal)this.mergeTraversal).getGValue());
        }
        if (this.onMatchTraversal instanceof GValueConstantTraversal && ((GValueConstantTraversal)this.onMatchTraversal).getGValue().isVariable()) {
            gValues.add(((GValueConstantTraversal)this.onMatchTraversal).getGValue());
        }
        if (this.onCreateTraversal instanceof GValueConstantTraversal && ((GValueConstantTraversal)this.onCreateTraversal).getGValue().isVariable()) {
            gValues.add(((GValueConstantTraversal)this.onCreateTraversal).getGValue());
        }
        return gValues;
    }

    @Override
    public CallbackRegistry<Event> getMutatingCallbackRegistry() {
        throw new IllegalStateException("Cannot get mutating CallbackRegistry on GValue placeholder step");
    }

    @Override
    public void addProperty(Object key, Object value) {
        if (key instanceof GValue) {
            throw new IllegalArgumentException("GValue cannot be used as a property key");
        }
        if (value instanceof GValue) {
            this.traversal.getGValueManager().register((GValue)value);
        }
        if (this.properties.containsKey(key)) {
            throw new IllegalArgumentException("MergeElement.addProperty only support properties with single cardinality");
        }
        this.properties.put(key, Collections.singletonList(value));
    }

    @Override
    public Map<Object, List<Object>> getProperties() {
        return GValueHelper.resolveProperties(this.properties, gValue -> this.traversal.getGValueManager().pinVariable(gValue.getName()));
    }

    @Override
    public Map<Object, List<Object>> getPropertiesWithGValues() {
        return Collections.unmodifiableMap(this.properties);
    }

    @Override
    public boolean removeProperty(Object k) {
        if (this.properties.containsKey(k)) {
            this.properties.remove(k);
            return true;
        }
        return false;
    }
}

