/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategies;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public class DefaultTraversalStrategies
implements TraversalStrategies {
    protected Set<TraversalStrategy<?>> traversalStrategies = new LinkedHashSet();

    @Override
    public TraversalStrategies addStrategies(TraversalStrategy<?> ... strategies) {
        for (TraversalStrategy<?> addStrategy : strategies) {
            this.getStrategy(addStrategy.getClass()).ifPresent(s -> this.traversalStrategies.remove(s));
        }
        Collections.addAll(this.traversalStrategies, strategies);
        this.traversalStrategies = TraversalStrategies.sortStrategies(this.traversalStrategies);
        return this;
    }

    @Override
    public TraversalStrategies removeStrategies(Class<? extends TraversalStrategy> ... strategyClasses) {
        boolean removed = false;
        for (Class<? extends TraversalStrategy> strategyClass : strategyClasses) {
            Optional<TraversalStrategy> strategy = this.traversalStrategies.stream().filter(s -> s.getClass().equals(strategyClass)).findAny();
            if (!strategy.isPresent()) continue;
            this.traversalStrategies.remove(strategy.get());
            removed = true;
        }
        if (removed) {
            this.traversalStrategies = TraversalStrategies.sortStrategies(this.traversalStrategies);
        }
        return this;
    }

    @Override
    public List<TraversalStrategy<?>> toList() {
        return Collections.unmodifiableList(new ArrayList(this.traversalStrategies));
    }

    @Override
    public Iterator<TraversalStrategy<?>> iterator() {
        return this.traversalStrategies.iterator();
    }

    @Override
    public <T extends TraversalStrategy> Optional<T> getStrategy(Class<T> traversalStrategyClass) {
        for (TraversalStrategy<?> traversalStrategy : this.traversalStrategies) {
            if (!traversalStrategyClass.isAssignableFrom(traversalStrategy.getClass())) continue;
            return Optional.of(traversalStrategy);
        }
        return Optional.empty();
    }

    @Override
    public DefaultTraversalStrategies clone() {
        try {
            DefaultTraversalStrategies clone = (DefaultTraversalStrategies)super.clone();
            clone.traversalStrategies = new LinkedHashSet(this.traversalStrategies.size());
            clone.traversalStrategies.addAll(this.traversalStrategies);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public String toString() {
        return StringFactory.traversalStrategiesString(this);
    }
}

