/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.views.jasperreports7.export;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRXmlExporter;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleXmlExporterOutput;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.ActionInvocation;
import org.apache.struts2.StrutsException;
import org.apache.struts2.views.jasperreports7.export.JasperReport7ExporterProvider;

public class JasperReport7XmlExporterProvider
implements JasperReport7ExporterProvider<JRXmlExporter> {
    private static final Logger LOG = LogManager.getLogger(JasperReport7XmlExporterProvider.class);

    @Override
    public JRXmlExporter createExporter(ActionInvocation invocation, JasperPrint jasperPrint) throws StrutsException {
        LOG.debug("Creating: {} exporter", (Object)this.getClass().getSimpleName());
        HttpServletResponse response = invocation.getInvocationContext().getServletResponse();
        response.setContentType("text/xml");
        JRXmlExporter exporter = new JRXmlExporter();
        SimpleExporterInput input = new SimpleExporterInput(jasperPrint);
        exporter.setExporterInput((ExporterInput)input);
        try (ServletOutputStream responseOutput = response.getOutputStream();){
            SimpleXmlExporterOutput exporterOutput = new SimpleXmlExporterOutput((OutputStream)responseOutput);
            exporter.setExporterOutput((ExporterOutput)exporterOutput);
        }
        catch (IOException e) {
            LOG.error("Error writing report XML output using: {}", (Object)JRXmlExporter.class.getName(), (Object)e);
            throw new StrutsException(e.getMessage(), (Throwable)e);
        }
        return exporter;
    }
}

