/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling.resource;

import java.util.Collections;
import java.util.Map;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.testing.mock.osgi.MockOsgi;
import org.apache.sling.testing.mock.sling.MockSling;
import org.apache.sling.testing.mock.sling.ResourceResolverType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.BundleContext;

public abstract class AbstractMultipleResourceResolverTest {
    private final BundleContext bundleContext = MockOsgi.newBundleContext();
    private ResourceResolverFactory resourceResolverFactory;

    protected abstract ResourceResolverType getResourceResolverType();

    protected ResourceResolverFactory newResourceResolerFactory() {
        return MockSling.newResourceResolverFactory((ResourceResolverType)this.getResourceResolverType(), (BundleContext)this.bundleContext);
    }

    @Before
    public void setUp() {
        this.resourceResolverFactory = this.newResourceResolerFactory();
    }

    @After
    public void tearDown() {
        MockOsgi.shutdown((BundleContext)this.bundleContext);
    }

    @Test
    public void testMultipleResourceResolver() throws Exception {
        ResourceResolver resolver1 = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
        ResourceResolver resolver2 = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
        Resource root = resolver1.getResource("/");
        resolver1.create(root, "test", Map.of());
        resolver1.commit();
        Resource testResource2 = resolver2.getResource("/test");
        Assert.assertNotNull((Object)testResource2);
        resolver2.delete(testResource2);
        resolver2.commit();
        Assert.assertNull((Object)resolver1.getResource("/test"));
    }

    @Test
    public void testIsResourceTypeWithAdminResourceResolver() throws Exception {
        ResourceResolver resourceResolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
        AbstractMultipleResourceResolverTest.createResourceAndCheckResourceType(resourceResolver);
    }

    @Test
    public void testIsResourceTypeWithNonAdminResourceResolver() throws Exception {
        ResourceResolver resourceResolver = this.resourceResolverFactory.getServiceResourceResolver(null);
        AbstractMultipleResourceResolverTest.createResourceAndCheckResourceType(resourceResolver);
    }

    private static void createResourceAndCheckResourceType(ResourceResolver serviceResolver) throws PersistenceException {
        Resource root = serviceResolver.getResource("/");
        Resource resource = serviceResolver.create(root, "testResource", Collections.singletonMap("sling:resourceType", "testResourceType"));
        Assert.assertTrue((String)"is expected resource type 'testResourceType'", (boolean)resource.isResourceType("testResourceType"));
        Assert.assertFalse((String)"is not unexpected resource type 'anotherResourceType'", (boolean)resource.isResourceType("anotherResourceType"));
    }
}

