/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.m2e.internal;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import org.apache.sling.ide.eclipse.m2e.internal.Activator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.m2e.internal.discovery.MavenDiscovery;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class BundleProjectNotSupportingM2EIncrementalBuildQuickFix
implements IMarkerResolutionGenerator {
    private static final String DEFAULT_DESCRIPTION = "Further information on how to configure the incremental build correctly is available in <a href=\"http://sling.apache.org/documentation/development/ide-tooling/ide-tooling-incremental-build.html\">http://sling.apache.org/documentation/development/ide-tooling/ide-tooling-incremental-build.html</a>";

    public IMarkerResolution[] getResolutions(IMarker marker) {
        IMarkerResolution[] resolutions = new IMarkerResolution[]{new InstallM2ETychoExtension(), new DescribeHowToConfigureMavenPluginsCorrectly()};
        return resolutions;
    }

    public static final class DescribeHowToConfigureMavenPluginsCorrectly
    implements IMarkerResolution {
        private static final String LABEL = "Use more recent maven-plugins with the right configuration";

        DescribeHowToConfigureMavenPluginsCorrectly() {
        }

        public String getLabel() {
            return LABEL;
        }

        public void run(IMarker marker) {
            MessageDialogWithLinkSection.openInformationWithLink(null, LABEL, "You need to configure the maven plugins appropriately and maybe upgrade to a newer version.", BundleProjectNotSupportingM2EIncrementalBuildQuickFix.DEFAULT_DESCRIPTION);
        }
    }

    public static final class InstallM2ETychoExtension
    implements IMarkerResolution {
        InstallM2ETychoExtension() {
        }

        public String getLabel() {
            return "Install m2e-tycho extension (incompatible with maven-bundle-plugin 3.2.0 and later)";
        }

        public void run(IMarker marker) {
            MavenDiscovery.launchWizard(Collections.singleton("bundle"), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        }
    }

    public static final class MessageDialogWithLinkSection
    extends MessageDialog {
        private final String linkText;

        public MessageDialogWithLinkSection(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex, String linkText) {
            super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
            this.linkText = linkText;
        }

        public static boolean openInformationWithLink(Shell parent, String title, String message, String link) {
            MessageDialogWithLinkSection dialog = new MessageDialogWithLinkSection(parent, title, null, message, 2, new String[]{IDialogConstants.OK_LABEL}, 0, link);
            return dialog.open() == 0;
        }

        protected Control createCustomArea(Composite parent) {
            Link link = new Link(parent, 64);
            link.setText(this.linkText);
            link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    try {
                        PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL(e.text));
                    }
                    catch (PartInitException ex) {
                        Activator.getDefault().getPluginLogger().error("Could not open external browser for link '" + e.text + "'", (Throwable)ex);
                    }
                    catch (MalformedURLException ex) {
                        Activator.getDefault().getPluginLogger().error("Invalid link detected '" + e.text + "'", (Throwable)ex);
                    }
                }
            });
            return link;
        }
    }
}

