/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.handler.impl;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.servicecomb.core.Endpoint;
import org.apache.servicecomb.core.Handler;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.exception.ExceptionUtils;
import org.apache.servicecomb.core.registry.discovery.EndpointDiscoveryFilter;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.registry.discovery.DiscoveryContext;
import org.apache.servicecomb.registry.discovery.DiscoveryFilter;
import org.apache.servicecomb.registry.discovery.DiscoveryTree;
import org.apache.servicecomb.registry.discovery.DiscoveryTreeNode;
import org.apache.servicecomb.swagger.invocation.AsyncResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleLoadBalanceHandler
implements Handler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleLoadBalanceHandler.class);
    private final DiscoveryTree discoveryTree = new DiscoveryTree();
    private final Map<String, AtomicInteger> indexMap = new ConcurrentHashMapEx();

    public SimpleLoadBalanceHandler() {
        this.discoveryTree.loadFromSPI(DiscoveryFilter.class);
        this.discoveryTree.addFilter((DiscoveryFilter)new EndpointDiscoveryFilter());
        this.discoveryTree.sort();
    }

    @Override
    public void handle(Invocation invocation, AsyncResponse asyncResp) throws Exception {
        if (invocation.getEndpoint() != null) {
            invocation.next(asyncResp);
            return;
        }
        DiscoveryContext context = new DiscoveryContext();
        context.setInputParameters((Object)invocation);
        DiscoveryTreeNode endpointsVersionedCache = this.discoveryTree.discovery(context, invocation.getAppId(), invocation.getMicroserviceName(), invocation.getMicroserviceVersionRule());
        if (endpointsVersionedCache.isEmpty()) {
            asyncResp.consumerFail((Throwable)ExceptionUtils.lbAddressNotFound(invocation.getMicroserviceName(), invocation.getMicroserviceVersionRule(), endpointsVersionedCache.name()));
            return;
        }
        List endpoints = (List)endpointsVersionedCache.data();
        AtomicInteger index = this.indexMap.computeIfAbsent(endpointsVersionedCache.name(), name -> {
            LOGGER.info("Create loadBalancer for {}.", name);
            return new AtomicInteger();
        });
        LOGGER.debug("invocation {} use discoveryGroup {}.", (Object)invocation.getMicroserviceQualifiedName(), (Object)endpointsVersionedCache.name());
        int idx = Math.abs(index.getAndIncrement());
        Endpoint endpoint = (Endpoint)endpoints.get(idx %= endpoints.size());
        invocation.setEndpoint(endpoint);
        invocation.next(asyncResp);
    }
}

