/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.governance;

import com.netflix.config.DynamicPropertyFactory;

public class GovernanceConfiguration {
    public static final String ROOT = "servicecomb.loadbalance.";
    public static final String RETRY_ENABLED = "retryEnabled";
    public static final String RETRY_ON_NEXT = "retryOnNext";
    public static final String RETRY_ON_SAME = "retryOnSame";
    public static final String WITH_DURATION = "waitDuration";

    public static boolean isRetryEnabled(String microservice) {
        String p = GovernanceConfiguration.getStringProperty("false", ROOT + microservice + "." + RETRY_ENABLED, "servicecomb.loadbalance.retryEnabled");
        return Boolean.parseBoolean(p);
    }

    public static int getRetryNextServer(String microservice) {
        return GovernanceConfiguration.getRetryServer(microservice, RETRY_ON_NEXT);
    }

    public static int getRetrySameServer(String microservice) {
        return GovernanceConfiguration.getRetryServer(microservice, RETRY_ON_SAME);
    }

    public static long getWithDuration(String microservice) {
        long defaultValue = 1L;
        String duration = GovernanceConfiguration.getStringProperty("1", ROOT + microservice + "." + WITH_DURATION, "servicecomb.loadbalance.waitDuration");
        try {
            long result = Long.parseLong(duration);
            if (result > 0L) {
                return result;
            }
            return 1L;
        }
        catch (NumberFormatException e) {
            return 1L;
        }
    }

    private static int getRetryServer(String microservice, String retryType) {
        boolean defaultValue = false;
        String p = GovernanceConfiguration.getStringProperty("0", ROOT + microservice + "." + retryType, ROOT + retryType);
        try {
            int result = Integer.parseInt(p);
            if (result > 0) {
                return result;
            }
            return 0;
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static String getStringProperty(String defaultValue, String ... keys) {
        for (String key : keys) {
            String property = DynamicPropertyFactory.getInstance().getStringProperty(key, null).get();
            if (property == null) continue;
            return property;
        }
        return defaultValue;
    }
}

