/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.exemplar;

import java.util.Set;
import javax.annotation.Nullable;
import org.apache.rocketmq.shaded.io.opentelemetry.api.common.AttributeKey;
import org.apache.rocketmq.shaded.io.opentelemetry.api.common.Attributes;
import org.apache.rocketmq.shaded.io.opentelemetry.api.trace.Span;
import org.apache.rocketmq.shaded.io.opentelemetry.api.trace.SpanContext;
import org.apache.rocketmq.shaded.io.opentelemetry.context.Context;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.common.Clock;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.data.DoubleExemplarData;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.data.LongExemplarData;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.data.ImmutableDoubleExemplarData;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.data.ImmutableLongExemplarData;

class ReservoirCell {
    private final Clock clock;
    @Nullable
    private Attributes attributes;
    private SpanContext spanContext = SpanContext.getInvalid();
    private long recordTime;
    private long longValue;
    private double doubleValue;

    ReservoirCell(Clock clock) {
        this.clock = clock;
    }

    synchronized void recordLongMeasurement(long value, Attributes attributes, Context context) {
        this.longValue = value;
        this.offerMeasurement(attributes, context);
    }

    synchronized void recordDoubleMeasurement(double value, Attributes attributes, Context context) {
        this.doubleValue = value;
        this.offerMeasurement(attributes, context);
    }

    private void offerMeasurement(Attributes attributes, Context context) {
        this.attributes = attributes;
        this.recordTime = this.clock.now();
        Span current = Span.fromContext(context);
        if (current.getSpanContext().isValid()) {
            this.spanContext = current.getSpanContext();
        }
    }

    @Nullable
    synchronized LongExemplarData getAndResetLong(Attributes pointAttributes) {
        Attributes attributes = this.attributes;
        if (attributes == null) {
            return null;
        }
        LongExemplarData result = ImmutableLongExemplarData.create(ReservoirCell.filtered(attributes, pointAttributes), this.recordTime, this.spanContext, this.longValue);
        this.reset();
        return result;
    }

    @Nullable
    synchronized DoubleExemplarData getAndResetDouble(Attributes pointAttributes) {
        Attributes attributes = this.attributes;
        if (attributes == null) {
            return null;
        }
        DoubleExemplarData result = ImmutableDoubleExemplarData.create(ReservoirCell.filtered(attributes, pointAttributes), this.recordTime, this.spanContext, this.doubleValue);
        this.reset();
        return result;
    }

    synchronized void reset() {
        this.attributes = null;
        this.longValue = 0L;
        this.doubleValue = 0.0;
        this.spanContext = SpanContext.getInvalid();
        this.recordTime = 0L;
    }

    private static Attributes filtered(Attributes original, Attributes metricPoint) {
        if (metricPoint.isEmpty()) {
            return original;
        }
        Set<AttributeKey<?>> metricPointKeys = metricPoint.asMap().keySet();
        return original.toBuilder().removeIf(metricPointKeys::contains).build();
    }
}

