/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.misc;

import apache.rocketmq.v2.ReceiveMessageRequest;
import com.github.luben.zstd.ZstdInputStream;
import com.github.luben.zstd.ZstdOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.zip.CRC32;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.InflaterInputStream;
import net.jpountz.lz4.LZ4FrameInputStream;
import net.jpountz.lz4.LZ4FrameOutputStream;

public class Utilities {
    public static final int MASTER_BROKER_ID = 0;
    public static final Locale LOCALE = new Locale("zh", "CN");
    private static final String OS_NAME = "os.name";
    private static final String OS_VERSION = "os.version";
    private static final Random RANDOM = new SecureRandom();
    private static final int PROCESS_ID_NOT_SET = -2;
    private static final int PROCESS_ID_NOT_FOUND = -1;
    private static int processId = -2;
    private static final String HOST_NAME_NOT_FOUND = "HOST_NAME_NOT_FOUND";
    private static final ThreadLocal<String> PROTOCOL_VERSION_THREAD_LOCAL = new ThreadLocal();
    private static final ThreadLocal<String> HOST_NAME_THREAD_LOCAL = new ThreadLocal();
    private static final ThreadLocal<byte[]> MAC_ADDRESS_THREAD_LOCAL = new ThreadLocal();
    private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] DIGITS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private Utilities() {
    }

    public static byte[] macAddress() {
        byte[] macAddress = MAC_ADDRESS_THREAD_LOCAL.get();
        if (null != macAddress) {
            return (byte[])macAddress.clone();
        }
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                byte[] mac = networkInterface.getHardwareAddress();
                if (null == mac) continue;
                macAddress = mac;
                MAC_ADDRESS_THREAD_LOCAL.set(macAddress);
                return (byte[])macAddress.clone();
            }
        }
        catch (Throwable networkInterfaces) {
            // empty catch block
        }
        byte[] randomBytes = new byte[6];
        RANDOM.nextBytes(randomBytes);
        macAddress = randomBytes;
        MAC_ADDRESS_THREAD_LOCAL.set(macAddress);
        return (byte[])macAddress.clone();
    }

    public static String getProtocolVersion() {
        String protocolVersion = PROTOCOL_VERSION_THREAD_LOCAL.get();
        if (null != protocolVersion) {
            return protocolVersion;
        }
        protocolVersion = ReceiveMessageRequest.class.getName().split("\\.")[2];
        PROTOCOL_VERSION_THREAD_LOCAL.set(protocolVersion);
        return protocolVersion;
    }

    public static int processId() {
        if (processId != -2) {
            return processId;
        }
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        String name = runtime.getName();
        try {
            processId = Integer.parseInt(name.substring(0, name.indexOf(64)));
        }
        catch (Throwable ignore) {
            processId = -1;
        }
        return processId;
    }

    public static String hostName() {
        String hostName = HOST_NAME_THREAD_LOCAL.get();
        if (null != hostName) {
            return hostName;
        }
        try {
            hostName = InetAddress.getLocalHost().getHostName();
            HOST_NAME_THREAD_LOCAL.set(hostName);
            return hostName;
        }
        catch (Throwable ignore) {
            hostName = HOST_NAME_NOT_FOUND;
            HOST_NAME_THREAD_LOCAL.set(hostName);
            return hostName;
        }
    }

    public static byte[] compressBytesGZIP(byte[] src) throws IOException {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(src.length);){
            try (GZIPOutputStream outputStream = new GZIPOutputStream(byteArrayOutputStream);){
                outputStream.write(src);
                ((FilterOutputStream)outputStream).flush();
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
    }

    public static byte[] compressBytesZSTD(byte[] src, int level) throws IOException {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(src.length);){
            try (ZstdOutputStream outputStream = new ZstdOutputStream((OutputStream)byteArrayOutputStream, level);){
                outputStream.write(src);
                outputStream.flush();
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
    }

    /*
     * Exception decompiling
     */
    public static byte[] compressBytesZLIB(byte[] src, int level) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static byte[] compressBytesLZ4(byte[] src) throws IOException {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(src.length);){
            try (LZ4FrameOutputStream outputStream = new LZ4FrameOutputStream((OutputStream)byteArrayOutputStream);){
                outputStream.write(src);
                outputStream.flush();
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] decompressBytes(byte[] src) throws IOException {
        byte[] uncompressData = new byte[src.length];
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(src);
        FilterInputStream filterInputStream = Utilities.getStreamByMagicCode(src, byteArrayInputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(src.length);
        try {
            int length;
            while ((length = filterInputStream.read(uncompressData, 0, uncompressData.length)) > 0) {
                byteArrayOutputStream.write(uncompressData, 0, length);
            }
            byteArrayOutputStream.flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        finally {
            try {
                byteArrayInputStream.close();
            }
            catch (IOException iOException) {}
            try {
                filterInputStream.close();
            }
            catch (IOException iOException) {}
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static FilterInputStream getStreamByMagicCode(byte[] src, InputStream inputStream) throws IOException {
        InflaterInputStream filterInputStream;
        if ((src[0] & 0xFF) == 31 && (src[1] & 0xFF) == 139) {
            filterInputStream = new GZIPInputStream(inputStream);
        } else if ((src[0] & 0xFF) == 120) {
            filterInputStream = new InflaterInputStream(inputStream);
        } else if ((src[0] & 0xFF) == 4 && (src[1] & 0xFF) == 34 && (src[2] & 0xFF) == 77 && (src[3] & 0xFF) == 24) {
            filterInputStream = new LZ4FrameInputStream(inputStream);
        } else if ((src[0] & 0xFF) == 40 && (src[1] & 0xFF) == 181 && (src[2] & 0xFF) == 47 && (src[3] & 0xFF) == 253) {
            filterInputStream = new ZstdInputStream(inputStream);
        } else {
            throw new IOException("Unknown compression format");
        }
        return filterInputStream;
    }

    public static String encodeHexString(ByteBuffer byteBuffer, boolean toLowerCase) {
        return new String(Utilities.encodeHex(byteBuffer, toLowerCase));
    }

    public static char[] encodeHex(ByteBuffer byteBuffer, boolean toLowerCase) {
        return Utilities.encodeHex(byteBuffer, toLowerCase ? DIGITS_LOWER : DIGITS_UPPER);
    }

    public static String encodeHexString(byte[] data, boolean toLowerCase) {
        return new String(Utilities.encodeHex(data, toLowerCase));
    }

    public static char[] encodeHex(byte[] data, boolean toLowerCase) {
        return Utilities.encodeHex(data, toLowerCase ? DIGITS_LOWER : DIGITS_UPPER);
    }

    protected static char[] encodeHex(ByteBuffer data, char[] toDigits) {
        return Utilities.encodeHex(data.array(), toDigits);
    }

    protected static char[] encodeHex(byte[] data, char[] toDigits) {
        int l = data.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = toDigits[(0xF0 & data[i]) >>> 4];
            out[j++] = toDigits[0xF & data[i]];
        }
        return out;
    }

    public static String crc32CheckSum(byte[] array) {
        CRC32 crc32 = new CRC32();
        crc32.update(array, 0, array.length);
        return Long.toHexString(crc32.getValue()).toUpperCase(LOCALE);
    }

    public static String md5CheckSum(byte[] array) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("MD5");
        digest.update(array);
        return Utilities.encodeHexString(digest.digest(), false);
    }

    public static String sha1CheckSum(byte[] array) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        digest.update(array);
        return Utilities.encodeHexString(digest.digest(), false);
    }

    public static String stackTrace() {
        return Utilities.stackTrace(Thread.getAllStackTraces());
    }

    public static String stackTrace(Map<Thread, StackTraceElement[]> map) {
        StringBuilder result = new StringBuilder();
        try {
            for (Map.Entry<Thread, StackTraceElement[]> entry : map.entrySet()) {
                StackTraceElement[] elements = entry.getValue();
                Thread thread = entry.getKey();
                if (elements == null || elements.length <= 0) continue;
                String threadName = entry.getKey().getName();
                result.append(String.format("%-40sTID: %d STATE: %s%n", new Object[]{threadName, thread.getId(), thread.getState()}));
                for (StackTraceElement el : elements) {
                    result.append(String.format("%-40s%s%n", threadName, el.toString()));
                }
                result.append("\n");
            }
        }
        catch (Throwable e) {
            result.append(e);
        }
        return result.toString();
    }

    public static String getOsDescription() {
        String osName = Utilities.getOsName();
        if (null == osName) {
            return "";
        }
        String version = Utilities.getOsVersion();
        return null != version ? osName + " " + version : osName;
    }

    public static String getOsName() {
        try {
            return System.getProperty(OS_NAME);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static String getOsVersion() {
        try {
            return System.getProperty(OS_VERSION);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static String getJavaDescription() {
        return System.getProperty("java.vm.vendor") + " " + System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version");
    }
}

