/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.krb;

import java.util.HashMap;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.security.krb.ConfigurationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeytabConfiguration
extends Configuration {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeytabConfiguration.class);
    private final String principal;
    private final String keytabFile;
    private final AppConfigurationEntry kerberosKeytabConfigEntry;

    public KeytabConfiguration(String principal, String keytabFile) {
        if (StringUtils.isBlank((CharSequence)principal)) {
            throw new IllegalArgumentException("Principal cannot be null");
        }
        if (StringUtils.isBlank((CharSequence)keytabFile)) {
            throw new IllegalArgumentException("Keytab file cannot be null");
        }
        this.principal = principal;
        this.keytabFile = keytabFile;
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("principal", principal);
        options.put("refreshKrb5Config", "true");
        if (ConfigurationUtil.IS_IBM) {
            options.put("useKeytab", keytabFile);
            options.put("credsType", "both");
        } else {
            options.put("keyTab", keytabFile);
            options.put("useKeyTab", "true");
            options.put("isInitiator", "true");
            options.put("doNotPrompt", "true");
            options.put("storeKey", "true");
        }
        String krbLoginModuleName = ConfigurationUtil.IS_IBM ? "com.ibm.security.auth.module.Krb5LoginModule" : "com.sun.security.auth.module.Krb5LoginModule";
        LOGGER.debug("krbLoginModuleName: {}, configuration options: {}", (Object)krbLoginModuleName, options);
        this.kerberosKeytabConfigEntry = new AppConfigurationEntry(krbLoginModuleName, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options);
    }

    @Override
    public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
        return new AppConfigurationEntry[]{this.kerberosKeytabConfigEntry};
    }

    public String getPrincipal() {
        return this.principal;
    }

    public String getKeytabFile() {
        return this.keytabFile;
    }
}

